/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;

public class EditPanel
extends JPanel
implements ActionListener,
IListener {
    public static final EditMode CREATION = EditMode.CREATION;
    public static final EditMode MODIFICATION = EditMode.MODIFICATION;
    public static final EditMode READONLY = EditMode.READONLY;
    private final EditMode mode;
    private JButton jButtonSupprimer;
    private JButton jButtonModifier;
    private JButton jButtonAjouter;
    private JButton jButtonAnnuler;
    private final SQLComponent component;
    private JCheckBox keepOpen = new JCheckBox("ne pas fermer la fen\u00eatre");
    private final List<EditPanelListener> panelListeners = new Vector<EditPanelListener>();
    private JScrollPane p;
    private final SQLElement element;
    private IListe l = null;
    private boolean valid;

    public EditPanel(SQLComponent e, EditMode mode) {
        this(e, mode, Collections.emptyList());
    }

    public EditPanel(SQLComponent e, EditMode mode, List<SQLField> hiddenFields) {
        this.mode = mode;
        this.element = e.getElement();
        this.component = e;
        try {
            this.component.setMode(mode.getCompMode());
            this.component.setNonExistantEditable(this.mode == CREATION);
            if (this.component instanceof BaseSQLComponent) {
                int i = 0;
                while (i < hiddenFields.size()) {
                    SQLField hiddenField = hiddenFields.get(i);
                    ((BaseSQLComponent)this.component).doNotShow(hiddenField);
                    ++i;
                }
            }
            if (this.mode == READONLY) {
                this.component.setEditable(false);
            } else {
                this.component.addValidListener(new ValidListener(){

                    @Override
                    public void validChange(ValidObject src, boolean newValue) {
                        EditPanel.this.valid = newValue;
                        EditPanel.this.updateBtns();
                    }
                });
                ((BaseSQLComponent)this.component).addSelectionListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        EditPanel.this.updateBtns();
                    }
                });
            }
            this.uiInit();
            this.component.uiInit();
            if (Boolean.getBoolean("org.openconcerto.editpanel.noborder")) {
                this.setInnerBorder(null);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle("Erreur d'initialisation", ex);
        }
    }

    private void updateBtns() {
        this.updateBtn(this.jButtonAjouter, true, false, "d'ajouter", "INSERT_ROW");
        this.updateBtn(this.jButtonModifier, true, true, "de modifier", "UPDATE_ROW");
        this.updateBtn(this.jButtonSupprimer, false, true, "de supprimer", "DELETE_ROW");
    }

    private void updateBtn(JButton b, boolean needValid, boolean needID, String desc, String code) {
        if (b != null) {
            boolean idOK = this.getSQLComponent().getSelectedID() >= 0;
            UserRights rights = UserRightsManager.getCurrentUserRights();
            String res = !TableAllRights.hasRight(rights, code, this.getSQLComponent().getElement().getTable()) ? "Vous n'avez pas le droit " + desc : (needID && !idOK ? "cet \u00e9l\u00e9ment n'existe pas" : (needValid && !this.valid ? this.component.getValidationText() : null));
            EditPanel.updateBtn(b, res == null, res);
        }
    }

    private final void uiInit() {
        this.fill();
        this.component.getInputMap(2).put(KeyStroke.getKeyStroke(10, 128), "add");
        this.component.getActionMap().put("add", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPanel.this.ajouter();
            }
        });
    }

    protected void fill() {
        EditPanel container = this;
        container.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 4;
        c.fill = 2;
        c.weighty = 1.0;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 1, 2);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        this.p = new JScrollPane(this.component);
        this.p.getVerticalScrollBar().setUnitIncrement(9);
        this.p.setOpaque(false);
        this.p.getViewport().setOpaque(false);
        container.add((Component)this.p, c);
        if (Boolean.getBoolean("org.openconcerto.editpanel.separator")) {
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 0;
            c.fill = 1;
            JSeparator comp = new JSeparator();
            comp.setMinimumSize(new Dimension(comp.getPreferredSize()));
            container.add((Component)comp, c);
        }
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        this.keepOpen.setOpaque(false);
        if (this.mode == CREATION) {
            c.gridx = 1;
            c.fill = 2;
            c.anchor = 13;
            if (!Boolean.getBoolean("org.openconcerto.editpanel.hideKeepOpen")) {
                container.add((Component)this.keepOpen, c);
            }
            this.keepOpen.addActionListener(this);
            c.fill = 0;
            c.gridx = 2;
            c.anchor = 13;
            this.jButtonAjouter = new JButton("Ajouter");
            container.add((Component)this.jButtonAjouter, c);
            this.jButtonAjouter.addActionListener(this);
            this.jButtonAjouter.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    String toolTipText;
                    if (!EditPanel.this.jButtonAjouter.isEnabled() && (toolTipText = EditPanel.this.jButtonAjouter.getToolTipText()) != null && !toolTipText.isEmpty()) {
                        JOptionPane.showMessageDialog(EditPanel.this, toolTipText);
                    }
                }
            });
        } else if (this.mode == MODIFICATION) {
            c.gridx = 1;
            c.anchor = 13;
            this.jButtonModifier = new JButton("Enregistrer les modifications");
            container.add((Component)this.jButtonModifier, c);
            c.weightx = 0.0;
            c.gridx = 2;
            this.jButtonSupprimer = new JButton("Supprimer");
            container.add((Component)this.jButtonSupprimer, c);
            this.jButtonModifier.addActionListener(this);
            this.jButtonSupprimer.addActionListener(this);
        }
        c.weightx = 0.0;
        c.gridx = 3;
        c.anchor = 13;
        this.jButtonAnnuler = this.mode == READONLY ? new JButton("Fermer") : new JButton("Annuler");
        container.add((Component)this.jButtonAnnuler, c);
        this.jButtonAnnuler.addActionListener(this);
    }

    public Dimension getViewResizedDimesion(Dimension frameSize) {
        Dimension viewSize = this.p.getViewport().getView().getSize();
        int verticalHidden = viewSize.height - this.p.getVerticalScrollBar().getVisibleAmount();
        int horizontalHidden = viewSize.width - this.p.getHorizontalScrollBar().getVisibleAmount();
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int maxV = (int)bounds.getMaxY() - this.getY();
        int maxH = (int)bounds.getMaxX() - this.getX();
        int vertical = Math.min(frameSize.height + verticalHidden, maxV);
        int horizontal = Math.min(frameSize.width + horizontalHidden, maxH);
        return new Dimension(horizontal, vertical);
    }

    public void setInnerBorder(Border b) {
        this.p.setBorder(b);
    }

    @Override
    public void selectionId(int id, int field) {
        if (id < 0) {
            this.component.select(null);
        } else if (this.mode == CREATION) {
            this.component.select(this.element.createCopy(id));
        } else {
            this.component.select(id);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButtonAnnuler) {
            try {
                this.fireCancelled();
            }
            catch (Throwable ex) {
                ExceptionHandler.handle("Erreur pendant l'annulation", ex);
            }
        } else if (e.getSource() == this.jButtonModifier) {
            try {
                this.modifier();
            }
            catch (Throwable ex) {
                ExceptionHandler.handle("Erreur pendant la modification", ex);
            }
        } else if (e.getSource() == this.jButtonAjouter) {
            try {
                this.ajouter();
            }
            catch (Throwable ex) {
                ExceptionHandler.handle("Erreur pendant l'ajout", ex);
            }
        } else if (e.getSource() == this.jButtonSupprimer) {
            try {
                if (this.element.askArchive((Component)this, this.component.getSelectedID())) {
                    this.fireDeleted();
                }
            }
            catch (Throwable ex) {
                ExceptionHandler.handle("Erreur pendant la suppression", ex);
            }
        }
    }

    public void modifier() {
        this.component.update();
        this.fireModified();
    }

    public boolean alwaysVisible() {
        return this.keepOpen.isSelected();
    }

    public void setAlwaysVisible(boolean b) {
        this.keepOpen.setSelected(true);
    }

    private void ajouter() {
        if (this.jButtonAjouter.isEnabled()) {
            int id = !Boolean.getBoolean("org.openconcerto.sql.editPanel.endAdd") && this.l != null && this.l.getDesiredRow() != null ? this.component.insert(this.l.getDesiredRow()) : this.component.insert();
            if (this.l != null) {
                this.l.selectID(id);
            }
            this.fireInserted(id);
        }
    }

    private void fireDeleted() {
        int i = 0;
        while (i < this.panelListeners.size()) {
            EditPanelListener listener = this.panelListeners.get(i);
            listener.deleted();
            ++i;
        }
    }

    private void fireInserted(int id) {
        int i = 0;
        while (i < this.panelListeners.size()) {
            EditPanelListener listener = this.panelListeners.get(i);
            listener.inserted(id);
            ++i;
        }
    }

    private void fireModified() {
        int i = 0;
        while (i < this.panelListeners.size()) {
            EditPanelListener listener = this.panelListeners.get(i);
            listener.modified();
            ++i;
        }
    }

    private void fireCancelled() {
        int i = 0;
        while (i < this.panelListeners.size()) {
            EditPanelListener listener = this.panelListeners.get(i);
            listener.cancelled();
            ++i;
        }
    }

    public void addEditPanelListener(EditPanelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        if (!this.panelListeners.contains(listener)) {
            this.panelListeners.add(listener);
        }
    }

    static void updateBtn(JButton btn, boolean valid, String cause) {
        btn.setEnabled(valid);
        btn.setToolTipText(EditPanel.computeTooltip(valid, cause));
    }

    static String computeTooltip(boolean valid, String cause) {
        String res;
        if (valid) {
            res = null;
        } else {
            String c = cause.trim();
            String validationText = "Les champs de saisie ne sont pas remplis correctement.\n\nVous ne pouvez enregistrer les modifications car";
            validationText = c.length() > 0 ? String.valueOf(validationText) + "\n" + c : String.valueOf(validationText) + " elles ne sont pas valides";
            res = "<html>" + validationText.replaceAll("\n", "<br>") + "</html>";
        }
        return res;
    }

    public void resetValue() {
        this.component.resetValue();
    }

    public void addComponentListenerOnViewPort(ComponentListener l) {
        this.p.getViewport().getView().addComponentListener(l);
    }

    public SQLComponent getSQLComponent() {
        return this.component;
    }

    public void setIList(IListe l) {
        this.l = l;
    }

    public static enum EditMode {
        CREATION{

            @Override
            protected SQLComponent.Mode getCompMode() {
                return SQLComponent.Mode.INSERTION;
            }
        }
        ,
        MODIFICATION{

            @Override
            protected SQLComponent.Mode getCompMode() {
                return SQLComponent.Mode.MODIFICATION;
            }
        }
        ,
        READONLY{

            @Override
            protected SQLComponent.Mode getCompMode() {
                return null;
            }
        };


        protected abstract SQLComponent.Mode getCompMode();
    }
}

