/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ReflectUtils;
import org.openconcerto.utils.cc.ITransformer;

public abstract class ChangeTable<T extends ChangeTable<T>> {
    public static final Set<ClauseType> ORDERED_TYPES;
    private String name;
    private final SQLSyntax syntax;
    private final List<Object[]> fks;
    private final CollectionMap<ClauseType, String> clauses;
    private final CollectionMap<ClauseType, DeferredClause> inClauses;
    private final CollectionMap<ClauseType, DeferredClause> outClauses;

    static {
        LinkedHashSet<ClauseType> tmp = new LinkedHashSet<ClauseType>(ClauseType.values().length);
        ConcatStep[] concatStepArray = ConcatStep.values();
        int n = concatStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConcatStep step = concatStepArray[n2];
            tmp.addAll(step.getTypes());
            ++n2;
        }
        assert (tmp.equals(EnumSet.allOf(ClauseType.class))) : "ConcatStep is missing some types : " + tmp;
        ORDERED_TYPES = Collections.unmodifiableSet(tmp);
    }

    public ChangeTable(SQLSyntax syntax, String name) {
        this.syntax = syntax;
        this.name = name;
        this.fks = new ArrayList<Object[]>();
        this.clauses = new CollectionMap();
        this.inClauses = new CollectionMap();
        this.outClauses = new CollectionMap();
        if (this.getClass() != ReflectUtils.getTypeArguments(this, ChangeTable.class).get(0)) {
            throw new IllegalStateException("illegal subclass: " + this.getClass());
        }
    }

    protected final T thisAsT() {
        return (T)this;
    }

    public final SQLSyntax getSyntax() {
        return this.syntax;
    }

    public void reset() {
        this.fks.clear();
        this.clauses.clear();
        this.inClauses.clear();
        this.outClauses.clear();
    }

    public final T addVarCharColumn(String name, int count) {
        return this.addColumn(name, "varchar(" + count + ") default '' NOT NULL");
    }

    public abstract T addColumn(String var1, String var2);

    private final String getConstraintPrefix() {
        return this instanceof AlterTable ? "ADD " : "";
    }

    public final T addClause(String s, ClauseType type) {
        this.clauses.put((Object)type, (Object)s);
        return this.thisAsT();
    }

    protected final List<String> getClauses(SQLName tableName, ClauseType type) {
        if (this.inClauses.size() == 0) {
            return (List)this.clauses.getNonNull(type);
        }
        ArrayList<String> res = new ArrayList<String>(this.clauses.getNonNull(type));
        for (DeferredClause c : this.inClauses.getNonNull(type)) {
            res.add(c.asString(this, tableName));
        }
        return res;
    }

    protected final List<String> getClauses(SQLName tableName, Collection<ClauseType> types) {
        ArrayList<String> res = new ArrayList<String>();
        for (ClauseType type : types) {
            res.addAll(this.getClauses(tableName, type));
        }
        return res;
    }

    protected final void outClausesAsString(StringBuffer res, final SQLName tableName, Set<ClauseType> types) {
        ArrayList<DeferredClause> clauses = new ArrayList<DeferredClause>();
        for (ClauseType type : types) {
            clauses.addAll(this.outClauses.getNonNull(type));
        }
        this.modifyOutClauses(clauses);
        if (clauses.size() > 0) {
            res.append("\n\n");
            res.append(CollectionUtils.join(clauses, "\n", new ITransformer<DeferredClause, String>(){

                @Override
                public String transformChecked(DeferredClause input) {
                    return input.asString(ChangeTable.this, tableName);
                }
            }));
        }
    }

    protected void modifyOutClauses(List<DeferredClause> clauses) {
    }

    public abstract String asString(String var1);

    protected final List<String> getForeignConstraints(String rootName) {
        ArrayList<String> res = new ArrayList<String>(this.fks.size());
        for (Object[] fk : this.fks) {
            List fieldName = (List)fk[0];
            SQLName relRefTable = (SQLName)fk[1];
            SQLName refTable = relRefTable.getItemCount() == 1 ? new SQLName(rootName, relRefTable.getName()) : relRefTable;
            List refCols = (List)fk[2];
            res.add(String.valueOf(this.getConstraintPrefix()) + this.getSyntax().getFK(String.valueOf(this.name) + "_", fieldName, refTable, refCols));
        }
        return res;
    }

    public String toString() {
        return this.asString(null);
    }

    public final String getName() {
        return this.name;
    }

    public static enum ClauseType {
        ADD_COL,
        ADD_CONSTRAINT,
        ADD_INDEX,
        DROP_COL,
        DROP_CONSTRAINT,
        DROP_INDEX,
        ALTER_COL,
        OTHER;

    }

    protected static enum ConcatStep {
        DROP_FOREIGN(ClauseType.DROP_CONSTRAINT),
        DROP_INDEX(ClauseType.DROP_INDEX),
        ALTER_TABLE(ClauseType.ADD_COL, ClauseType.DROP_COL, ClauseType.ALTER_COL, ClauseType.OTHER),
        ADD_INDEX(ClauseType.ADD_INDEX),
        ADD_FOREIGN(ClauseType.ADD_CONSTRAINT);

        private final Set<ClauseType> types = new HashSet<ClauseType>();

        private ConcatStep(ClauseType ... types) {
            ClauseType[] clauseTypeArray = types;
            int n2 = types.length;
            int n3 = 0;
            while (n3 < n2) {
                ClauseType t = clauseTypeArray[n3];
                this.types.add(t);
                ++n3;
            }
        }

        public final Set<ClauseType> getTypes() {
            return this.types;
        }
    }

    public static interface DeferredClause {
        public String asString(ChangeTable<?> var1, SQLName var2);
    }

    public static abstract class OutsideClause
    implements DeferredClause {
        public abstract String asString(SQLName var1);

        @Override
        public String asString(ChangeTable<?> ct, SQLName tableName) {
            return this.asString(tableName);
        }
    }
}

