/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public final class AlterTable
extends ChangeTable<AlterTable> {
    private final SQLTable t = null;

    AlterTable(SQLSyntax s, String tableName) {
        super(s, tableName);
    }

    @Override
    public final AlterTable addColumn(String name, String definition) {
        return (AlterTable)this.addClause("ADD " + SQLBase.quoteIdentifier(name) + " " + definition, ChangeTable.ClauseType.ADD_COL);
    }

    @Override
    public String asString(String rootName) {
        return this.asString(rootName, ChangeTable.ORDERED_TYPES);
    }

    private final String asString(String rootName, Set<ChangeTable.ClauseType> types) {
        SQLName tableName = new SQLName(rootName, this.getName());
        ArrayList<String> genClauses = new ArrayList<String>(this.getClauses(tableName, types));
        this.modifyClauses(genClauses);
        if (types.contains((Object)ChangeTable.ClauseType.ADD_CONSTRAINT)) {
            genClauses.addAll(this.getForeignConstraints(rootName));
        }
        StringBuffer res = new StringBuffer(512);
        final String alterTable = "ALTER TABLE " + tableName.quote();
        if (this.getSyntax().supportMultiAlterClause() && genClauses.size() > 0) {
            res.append(String.valueOf(alterTable) + " \n");
            res.append(CollectionUtils.join(genClauses, ",\n"));
            res.append(";");
        } else {
            res.append(CollectionUtils.join(genClauses, "\n", new ITransformer<String, String>(){

                @Override
                public String transformChecked(String input) {
                    return String.valueOf(alterTable) + " " + input + ";";
                }
            }));
        }
        this.outClausesAsString(res, tableName, types);
        return res.toString();
    }

    protected void modifyClauses(List<String> genClauses) {
    }
}

