/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.LockAdminUserRight;
import org.openconcerto.sql.users.rights.MacroRight;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.ITransformer;

public class UserRightsManager {
    private static UserRightsManager instance;
    private static final CollectionMap<String, Tuple2<String, Boolean>> SUPERUSER_RIGHTS;
    private final Map<String, MacroRight> macroRights = new HashMap<String, MacroRight>();
    private final Map<Integer, CollectionMap<String, Tuple2<String, Boolean>>> rights = new HashMap<Integer, CollectionMap<String, Tuple2<String, Boolean>>>();
    private SQLTable table = null;
    private final CollectionMap<Integer, RightTuple> javaRights = new CollectionMap();

    static {
        SUPERUSER_RIGHTS = CollectionMap.singleton(null, Tuple2.create(null, true));
    }

    public static synchronized UserRightsManager getInstance() {
        if (instance == null) {
            instance = new UserRightsManager();
        }
        return instance;
    }

    public static final UserRights getCurrentUserRights() {
        UserManager mngr = UserManager.getInstance();
        if (!UserRightsManager.getInstance().isValid()) {
            return new UserRights(-1){

                @Override
                public boolean haveRight(String code, String object) {
                    return true;
                }
            };
        }
        if (mngr.getCurrentUser() == null) {
            return new UserRights(mngr.getTable().getUndefinedID());
        }
        return mngr.getCurrentUser().getRights();
    }

    private UserRightsManager() {
        this.defaultRegister();
    }

    private void defaultRegister() {
        this.register(new LockAdminUserRight());
        this.register(new TableAllRights(true));
        this.register(new TableAllRights(false));
    }

    public void register(MacroRight userRight) {
        this.macroRights.put(userRight.getCode(), userRight);
    }

    public final boolean isValid() {
        return this.getTable() != null;
    }

    public final SQLTable getTable() {
        if (this.table == null) {
            this.table = Configuration.getInstance().getRoot().findTable("USER_RIGHT");
            if (this.table != null) {
                this.table.addTableModifiedListener(new SQLTableModifiedListener(){

                    @Override
                    public void tableModified(SQLTableEvent evt) {
                        UserRightsManager.this.rightsInvalid();
                    }
                });
            }
        }
        return this.table;
    }

    public final DBRoot getRoot() {
        return this.getTable().getDBRoot();
    }

    public final boolean haveRight(int userID, String code, String object) {
        HashSet<String> unicity = new HashSet<String>();
        Boolean userRight = this.haveRightP(userID, code, object, unicity);
        if (userRight != null) {
            return userRight;
        }
        Boolean defaultRight = this.haveRightP(this.getTable().getForeignTable("ID_USER_COMMON").getUndefinedID(), code, object, unicity);
        if (defaultRight != null) {
            return defaultRight;
        }
        return false;
    }

    private final Boolean haveRightP(int userID, String code, String object, Set<String> unicity) {
        CollectionMap<String, Tuple2<String, Boolean>> rightsForUser = this.getRightsForUser(userID);
        if (rightsForUser == SUPERUSER_RIGHTS) {
            return true;
        }
        if (rightsForUser.containsKey(code)) {
            for (Tuple2<String, Boolean> t : rightsForUser.getNonNull(code)) {
                if (!unicity.add(t.get0())) continue;
                if (t.get0() == null || t.get0().equals(object)) {
                    return t.get1();
                }
                if (object != null || t.get1().booleanValue()) continue;
                return false;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rightsInvalid() {
        Map<Integer, CollectionMap<String, Tuple2<String, Boolean>>> map = this.rights;
        synchronized (map) {
            this.rights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectionMap<String, Tuple2<String, Boolean>> getRightsForUser(int userID) {
        Map<Integer, CollectionMap<String, Tuple2<String, Boolean>>> map = this.rights;
        synchronized (map) {
            if (this.rights.containsKey(userID)) {
                return this.rights.get(userID);
            }
            CollectionMap<String, Tuple2<String, Boolean>> rightsForUser = this.loadRightsForUser(userID);
            this.rights.put(userID, rightsForUser);
            return rightsForUser;
        }
    }

    private final CollectionMap<String, Tuple2<String, Boolean>> loadRightsForUser(final int userID) {
        try {
            SQLRow userRow = this.getTable().getForeignTable("ID_USER_COMMON").getRow(userID);
            if (userRow != null && userRow.getBoolean("SUPERUSER").booleanValue()) {
                return SUPERUSER_RIGHTS;
            }
            CollectionMap<String, Tuple2<String, Boolean>> res = new CollectionMap<String, Tuple2<String, Boolean>>(ArrayList.class);
            HashSet<Tuple2<String, String>> unicity = new HashSet<Tuple2<String, String>>();
            this.expand(res, unicity, TableAllRights.createRight("TABLE_ALL_MODIF_RIGHTS", this.getTable().getForeignTable("ID_RIGHT"), false));
            this.expand(res, unicity, TableAllRights.createRight("TABLE_ALL_RIGHTS", this.getTable(), userRow != null && userRow.getBoolean("ADMIN") != false));
            for (RightTuple t : this.javaRights.getNonNull(userID)) {
                this.expand(res, unicity, t);
            }
            for (RightTuple t : this.javaRights.getNonNull(null)) {
                this.expand(res, unicity, t);
            }
            SQLRowValues vals = new SQLRowValues(this.getTable()).setAllToNull();
            vals.putRowValues("ID_RIGHT").setAllToNull();
            SQLRowValuesListFetcher sel = new SQLRowValuesListFetcher(vals);
            sel.setOrdered(true);
            sel.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect sel) {
                    sel.setWhere(new Where((FieldRef)UserRightsManager.this.getTable().getField("ID_USER_COMMON"), "=", userID));
                    return sel;
                }
            });
            List<SQLRowValues> list = sel.fetch();
            for (SQLRowValues row : list) {
                SQLRowAccessor right = row.getForeign("ID_RIGHT");
                if (row.isUndefined()) {
                    Log.get().warning(row.asRow() + " has undef right");
                    continue;
                }
                String rightCode = right.getString("CODE");
                if (rightCode == null) {
                    Log.get().warning(right + " has null CODE");
                    continue;
                }
                String object = row.getString("OBJECT");
                Boolean haveRight = row.getBoolean("HAVE_RIGHT");
                this.expand(res, unicity, rightCode, object, haveRight);
            }
            return res;
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur lors du chargement des droits utilisateurs pour l'utilisateur (Id:" + userID + ")", e);
            return SUPERUSER_RIGHTS;
        }
    }

    private final void expand(CollectionMap<String, Tuple2<String, Boolean>> res, Set<Tuple2<String, String>> unicity, RightTuple t) {
        this.expand(res, unicity, (String)t.get0(), (String)t.get1(), (Boolean)t.get2());
    }

    private final void expand(CollectionMap<String, Tuple2<String, Boolean>> res, Set<Tuple2<String, String>> unicity, String rightCode, String object, Boolean haveRight) {
        if (haveRight == null) {
            throw new IllegalStateException("HAVE_RIGHT cannot be null");
        }
        if (this.macroRights.containsKey(rightCode)) {
            for (RightTuple t : this.macroRights.get(rightCode).expand(this, rightCode, object, haveRight)) {
                this.expand(res, unicity, t);
            }
        } else if (unicity.add(Tuple2.create(rightCode, object))) {
            res.put((Object)rightCode, Tuple2.create(object, haveRight));
        }
    }

    public static final class RightTuple
    extends Tuple3<String, String, Boolean> {
        public RightTuple(String code, boolean haveRight) {
            this(code, null, haveRight);
        }

        public RightTuple(String code, String object, boolean haveRight) {
            super(code, object, haveRight);
        }
    }
}

