/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRightsManager;

public class UserRights {
    private final int userID;

    public UserRights(int userID) {
        this.userID = userID;
    }

    public boolean haveRight(String code, String object) {
        return UserRightsManager.getInstance().haveRight(this.userID, code, object);
    }

    public final boolean canDelete(SQLTable table) {
        return TableAllRights.hasRight(this, "DELETE_ROW", table);
    }

    public final boolean canModify(SQLTable table) {
        return TableAllRights.hasRight(this, "UPDATE_ROW", table);
    }

    public final boolean canAdd(SQLTable table) {
        return TableAllRights.hasRight(this, "INSERT_ROW", table);
    }

    public final boolean canView(SQLTable table) {
        return TableAllRights.hasRight(this, "SELECT_ROW", table);
    }
}

