/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.MacroRight;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;

public class TableAllRights
extends MacroRight {
    public static UserRightsManager.RightTuple createRight(SQLTable t, boolean b) {
        return TableAllRights.createRight("TABLE_ALL_RIGHTS", t, b);
    }

    public static UserRightsManager.RightTuple createRight(String code, SQLTable t, boolean b) {
        return new UserRightsManager.RightTuple(code, TableAllRights.tableToString(t), b);
    }

    public static boolean hasRight(UserRights u, String code, SQLTable t) {
        return u.haveRight(code, TableAllRights.tableToString(t));
    }

    static String tableToString(SQLTable t) {
        return t == null ? null : t.getSQLName(t.getDBRoot()).quote();
    }

    public TableAllRights() {
        this(true);
    }

    public TableAllRights(boolean includeView) {
        super(includeView ? "TABLE_ALL_RIGHTS" : "TABLE_ALL_MODIF_RIGHTS");
    }

    @Override
    public List<UserRightsManager.RightTuple> expand(UserRightsManager mngr, String rightCode, String object, boolean haveRight) {
        ArrayList<UserRightsManager.RightTuple> res = new ArrayList<UserRightsManager.RightTuple>();
        res.add(new UserRightsManager.RightTuple("DELETE_ROW", object, haveRight));
        res.add(new UserRightsManager.RightTuple("UPDATE_ROW", object, haveRight));
        res.add(new UserRightsManager.RightTuple("INSERT_ROW", object, haveRight));
        if (this.getCode() == "TABLE_ALL_RIGHTS") {
            res.add(new UserRightsManager.RightTuple("SELECT_ROW", object, haveRight));
        }
        return res;
    }
}

