/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject.itemview;

import java.awt.Component;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.itemview.BaseRowItemView;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.checks.ChainValidListener;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.EmptyObjFromVO;
import org.openconcerto.utils.checks.EmptyObjHelper;
import org.openconcerto.utils.checks.ValidListener;

public abstract class VWRowItemView<T>
extends BaseRowItemView {
    private final ValueWrapper<T> wrapper;
    private EmptyObjHelper helper;

    public VWRowItemView(ValueWrapper<T> wrapper) {
        this.wrapper = wrapper;
    }

    public final ValueWrapper<T> getWrapper() {
        return this.wrapper;
    }

    @Override
    protected void init() {
        this.helper = this.createHelper();
    }

    private final EmptyObjHelper createHelper() {
        EmptyObj eo = this.getWrapper() instanceof EmptyObj ? (EmptyObjFromVO<T>)((Object)this.getWrapper()) : (this.getWrapper().getComp() instanceof EmptyObj ? (EmptyObj)((Object)this.getWrapper().getComp()) : new EmptyObjFromVO<T>(this.getWrapper(), this.getEmptyPredicate()));
        return new EmptyObjHelper(this, eo);
    }

    protected IPredicate<T> getEmptyPredicate() {
        return EmptyObjFromVO.getDefaultPredicate();
    }

    @Override
    public void resetValue() {
        this.getWrapper().resetValue();
    }

    @Override
    public void show(SQLRowAccessor r) {
        if (r.getFields().contains(this.getField().getName())) {
            this.getWrapper().setValue(r.getObject(this.getField().getName()));
        }
    }

    @Override
    public void update(SQLRowValues vals) {
        vals.put(this.getField().getName(), this.isEmpty() ? SQLRowValues.SQL_DEFAULT : this.getWrapper().getValue());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " using " + this.getWrapper();
    }

    @Override
    public final boolean isEmpty() {
        return this.helper.isEmpty();
    }

    @Override
    public final void addEmptyListener(EmptyListener l) {
        this.helper.addEmptyListener(l);
    }

    @Override
    public final boolean isValidated() {
        return this.getWrapper().isValidated();
    }

    @Override
    public final void addValidListener(ValidListener l) {
        this.getWrapper().addValidListener(new ChainValidListener(this, l));
    }

    @Override
    public String getValidationText() {
        return this.getWrapper().getValidationText();
    }

    @Override
    public final Component getComp() {
        return this.getWrapper().getComp();
    }
}

