/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.util.Collection;
import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.combo.ISearchableTextCombo;
import org.openconcerto.utils.change.CollectionChangeEvent;
import org.openconcerto.utils.change.IListDataEvent;
import org.openconcerto.utils.model.DefaultIMutableListModel;

public class SQLSearchableTextCombo
extends ISearchableTextCombo
implements RowItemViewComponent {
    public SQLSearchableTextCombo() {
        this(ComboLockedMode.UNLOCKED);
    }

    public SQLSearchableTextCombo(boolean locked) {
        super(locked);
    }

    public SQLSearchableTextCombo(ComboLockedMode mode) {
        super(mode);
    }

    public SQLSearchableTextCombo(ComboLockedMode mode, int rows, int columns) {
        super(mode, rows, columns);
    }

    public SQLSearchableTextCombo(ComboLockedMode mode, boolean textArea) {
        super(mode, textArea);
    }

    public SQLSearchableTextCombo(ComboLockedMode mode, int rows, int columns, boolean textArea) {
        super(mode, rows, columns, textArea);
    }

    @Override
    public void init(SQLRowItemView v) {
        this.initCacheLater(new ISQLListModel(v.getField()));
    }

    public void initCacheLater(final ISQLListModel cache) {
        cache.load(new Runnable(){

            @Override
            public void run() {
                SQLSearchableTextCombo.this.initCache(cache);
            }
        });
    }

    public static class ISQLListModel
    extends DefaultIMutableListModel<String> {
        private final SQLTextCombo.ITextComboCacheSQL cache;
        private final ListDataListener l;

        public ISQLListModel(SQLField f) {
            this(new SQLTextCombo.ITextComboCacheSQL(f));
        }

        public ISQLListModel(SQLTextCombo.ITextComboCacheSQL c) {
            this.cache = c;
            this.l = new ListDataListener(){

                @Override
                public void contentsChanged(ListDataEvent e) {
                    if (e.getIndex0() < 0) {
                        return;
                    }
                    CollectionChangeEvent evt = ((IListDataEvent)e).getCollectionChangeEvent();
                    this.remove(evt);
                    this.add(evt.getItemsAdded());
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                    this.add(ISQLListModel.this.getList().subList(e.getIndex0(), e.getIndex1() + 1));
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    this.remove(((IListDataEvent)e).getCollectionChangeEvent());
                }

                private void add(Collection<String> toAdd) {
                    for (String s : toAdd) {
                        ISQLListModel.this.cache.addToCache(s);
                    }
                }

                private void remove(CollectionChangeEvent evt) {
                    for (String s : evt.getItemsRemoved()) {
                        ISQLListModel.this.cache.deleteFromCache(s);
                    }
                }
            };
        }

        private void load(final Runnable r) {
            if (this.cache.isValid()) {
                new SwingWorker<List<String>, Object>(){

                    @Override
                    protected List<String> doInBackground() throws Exception {
                        return ISQLListModel.this.cache.loadCache();
                    }

                    @Override
                    protected void done() {
                        ISQLListModel.this.removeListDataListener(ISQLListModel.this.l);
                        ISQLListModel.this.removeAllElements();
                        try {
                            ISQLListModel.this.addAll((Collection)this.get());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        ISQLListModel.this.addListDataListener(ISQLListModel.this.l);
                        if (r != null) {
                            r.run();
                        }
                    }
                }.execute();
            }
        }
    }
}

