/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.Predicate;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.ITextWithCompletion;
import org.openconcerto.sql.sqlobject.SelectionListener;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JMultiLineToolTip;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.OrderedSet;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.EmptyObject;
import org.openconcerto.utils.checks.EmptyObjectHelper;
import org.openconcerto.utils.checks.ValidListener;

public class ISQLElementWithCodeSelector
extends JPanel
implements ValueWrapper<Integer>,
EmptyObject,
RowItemViewComponent,
SelectionListener,
ActionListener,
TextComponent {
    private int id = -1;
    private OrderedSet<ValidListener> validListener = new OrderedSet();
    private EmptyObjectHelper emptyHelper;
    private PropertyChangeSupport supp;
    private SQLElement element;
    private SQLField optField;
    private SQLField mainField;
    ComboSQLRequest mainCombo;
    ComboSQLRequest optCombo;
    protected JButton addButton;
    boolean updating;
    boolean disableCompletion = false;
    private JImage warning;
    private ITextWithCompletion textMain;
    private ITextWithCompletion textOpt;
    public SQLRowValues defaultCreateRowValues;
    private static ImageIcon icon = null;
    private JButton viewButton = new JButton(){

        @Override
        public JToolTip createToolTip() {
            return new JMultiLineToolTip();
        }
    };
    private EditFrame viewFrame = null;

    public ISQLElementWithCodeSelector(SQLElement e, SQLField optField) {
        this(e, optField, null);
    }

    public ISQLElementWithCodeSelector(SQLElement e, SQLField optField, SQLRowValues defaultCreateRowValues) {
        this.optField = optField;
        this.element = e;
        this.updating = false;
        this.supp = new PropertyChangeSupport(this);
        this.emptyHelper = new EmptyObjectHelper(this, new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                return ISQLElementWithCodeSelector.this.id == -1;
            }
        });
        this.defaultCreateRowValues = defaultCreateRowValues == null ? new SQLRowValues(e.getTable()) : defaultCreateRowValues;
    }

    @Override
    public void init(SQLRowItemView riv) {
        this.init(false);
    }

    protected boolean init(boolean expandWithShowAs) {
        this.setOpaque(false);
        this.mainCombo = this.element.getComboRequest();
        this.mainField = (SQLField)this.mainCombo.getFields().iterator().next();
        if (expandWithShowAs) {
            this.optCombo = new ComboSQLRequest(this.element.getComboRequest());
        } else {
            ArrayList<String> optFields = new ArrayList<String>();
            optFields.add(this.optField.getName());
            this.optCombo = new ComboSQLRequest(this.element.getTable(), optFields);
        }
        this.uiInit();
        this.textMain.addSelectionListener(this);
        this.textOpt.addSelectionListener(this);
        if (expandWithShowAs) {
            this.textMain.setFillWithField(this.mainField.getName());
            this.textOpt.setFillWithField(this.optField.getName());
        }
        return true;
    }

    private void uiInit() {
        if (icon == null) {
            icon = new ImageIcon(ISQLElementWithCodeSelector.class.getResource("loupe.png"));
        }
        this.viewButton.setBorder(null);
        this.viewButton.setOpaque(false);
        this.viewButton.setPreferredSize(new Dimension(24, 16));
        this.viewButton.setFocusPainted(false);
        this.viewButton.setEnabled(false);
        this.addEmptyListener(new EmptyListener(){

            @Override
            public void emptyChange(EmptyObj src, boolean newValue) {
                ISQLElementWithCodeSelector.this.viewButton.setEnabled(!ISQLElementWithCodeSelector.this.isEmpty());
            }
        });
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = -1;
        this.textMain = new ITextWithCompletion(this.mainCombo, false);
        c.weightx = 1.0;
        this.textMain.setPreferredSize(new Dimension(160, (int)this.textMain.getPreferredSize().getHeight()));
        this.textMain.setMinimumSize(new Dimension(160, (int)this.textMain.getPreferredSize().getHeight()));
        this.add((Component)this.textMain, c);
        c.insets = new Insets(0, 3, 0, 2);
        this.warning = new JImage(ISQLElementWithCodeSelector.class.getResource("warning.png"));
        c.weightx = 0.0;
        this.add((Component)this.warning, c);
        JLabel labelCode = this.getLabelFor(this.optField);
        c.weightx = 0.0;
        this.add((Component)labelCode, c);
        this.textOpt = new ITextWithCompletion(this.optCombo, false);
        this.textOpt.setPreferredSize(new Dimension(100, (int)this.textOpt.getPreferredSize().getHeight()));
        this.textOpt.setMinimumSize(new Dimension(100, (int)this.textOpt.getPreferredSize().getHeight()));
        c.weightx = 1.0;
        this.add((Component)this.textOpt, c);
        this.addButton = new JButton("Cr\u00e9er " + this.element.getSingularName());
        this.addButton.addActionListener(this);
        c.fill = 0;
        c.weightx = 0.0;
        this.add((Component)this.addButton, c);
        this.viewButton.setIcon(icon);
        this.viewButton.setContentAreaFilled(false);
        this.add((Component)this.viewButton, c);
        this.viewButton.addActionListener(this);
    }

    @Override
    public void setValue(Integer val) {
        this.selectId(val);
    }

    @Override
    public void resetValue() {
    }

    @Override
    public Object getUncheckedValue() {
        return this.getValue();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.textOpt.setEditable(b);
        this.textMain.setEditable(b);
        this.addButton.setEnabled(b);
    }

    @Override
    public Integer getValue() throws IllegalStateException {
        return this.getSelectedId();
    }

    private int getSelectedId() {
        return this.id;
    }

    @Override
    public boolean isEmpty() {
        return this.emptyHelper.isEmpty();
    }

    @Override
    public void addEmptyListener(EmptyListener l) {
        this.emptyHelper.addListener(l);
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    public void removeValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void addValidListener(ValidListener l) {
        if (!this.validListener.contains(l)) {
            this.validListener.add(l);
        }
    }

    public JLabel getLabelFor(SQLField aField) {
        return new JLabel(Configuration.getTranslator(aField.getTable()).getLabelFor(aField));
    }

    void selectId(int anId) {
        this.setId(anId);
        this.textMain.selectId(anId);
        this.textOpt.selectId(anId);
    }

    private void setId(int id) {
        this.id = id < 0 ? -1 : id;
        this.warning.setVisible(this.id == -1);
        this.supp.firePropertyChange("value", null, this.getUncheckedValue());
    }

    @Override
    public void idSelected(int anId, Object source) {
        if (source == this.textOpt) {
            this.textMain.selectId(anId);
        } else {
            this.textOpt.selectId(anId);
        }
        this.setId(anId);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.viewButton) {
            if (this.viewFrame == null) {
                this.viewFrame = new EditFrame(this.element, EditPanel.MODIFICATION);
            }
            this.viewFrame.selectionId(this.getSelectedId());
            if (!this.viewFrame.isShowing()) {
                this.viewFrame.setVisible(true);
            } else {
                this.viewFrame.setVisible(false);
            }
        } else if (e.getSource() == this.addButton) {
            EditFrame edit = new EditFrame(this.element);
            this.defaultCreateRowValues.put(this.mainField.getName(), this.textMain.getText());
            this.defaultCreateRowValues.put(this.optField.getName(), this.textOpt.getText());
            edit.getPanel().getSQLComponent().select(this.defaultCreateRowValues);
            edit.setVisible(true);
            edit.addEditPanelListener(new EditPanelListener(){

                @Override
                public void cancelled() {
                }

                @Override
                public void deleted() {
                }

                @Override
                public void inserted(int mid) {
                    ISQLElementWithCodeSelector.this.textMain.loadCache();
                    ISQLElementWithCodeSelector.this.textOpt.loadCache();
                    ISQLElementWithCodeSelector.this.selectId(mid);
                }

                @Override
                public void modified() {
                }
            });
        }
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public JTextComponent getTextComp() {
        return this.textMain.getTextComp();
    }

    public String getTextMain() {
        return this.textMain.getText().toString();
    }

    public String getTextOpt() {
        return this.textOpt.getText().toString();
    }

    public void loadCache() {
        this.textMain.loadCache();
        this.textOpt.loadCache();
    }

    @Override
    public String getValidationText() {
        return "aucun champ n'est s\u00e9lectionn\u00e9";
    }

    public void setWhereOnRequest(Where w) {
        this.mainCombo.setWhere(w);
        this.optCombo.setWhere(w);
        this.loadCache();
    }
}

