/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListener;
import org.openconcerto.sql.request.BaseSQLRequest;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.ui.SwingThreadUtils;

public class SQLRowView
extends BaseSQLRequest {
    private final SQLTable table;
    private final SQLTableListener tableListener;
    private int selectedID;
    private final Map<String, SQLRowItemView> views;
    private boolean filling;
    private boolean updating;
    private final PropertyChangeSupport supp;

    public SQLRowView(SQLTable t) {
        if (t == null) {
            throw new NullPointerException("null SQLTable");
        }
        if (!t.isRowable()) {
            throw new IllegalArgumentException(t + " is not rowable");
        }
        this.supp = new PropertyChangeSupport(this);
        this.table = t;
        this.views = new HashMap<String, SQLRowItemView>();
        this.filling = false;
        this.updating = false;
        this.selectedID = -1;
        this.tableListener = new SQLTableListener(){

            @Override
            public void rowModified(SQLTable t, int id) {
                if (!SQLRowView.this.isUpdating() && SQLRowView.this.existsInDB()) {
                    if (!t.equals(SQLRowView.this.getTable())) {
                        Thread.dumpStack();
                    } else if (SQLRowView.this.getSelectedID() == id) {
                        SQLRowView.this.select(id);
                    }
                }
            }

            @Override
            public void rowAdded(SQLTable t, int id) {
            }

            @Override
            public void rowDeleted(SQLTable t, int id) {
                if (!SQLRowView.this.isUpdating() && SQLRowView.this.existsInDB()) {
                    if (!t.equals(SQLRowView.this.getTable())) {
                        Thread.dumpStack();
                    } else if (SQLRowView.this.getSelectedID() == id) {
                        SwingThreadUtils.invoke(new Runnable(){

                            @Override
                            public void run() {
                                SQLRowView.this.select(null);
                            }
                        });
                    }
                }
            }
        };
    }

    public synchronized boolean isUpdating() {
        return this.updating;
    }

    public final void activate(boolean b) {
        if (b) {
            this.table.addTableListener(this.tableListener);
            if (this.existsInDB()) {
                this.select(this.getSelectedID());
            }
        } else {
            this.table.removeTableListener(this.tableListener);
        }
    }

    public void add(SQLRowItemView obj) {
        if (obj.getSQLName() == null) {
            throw new IllegalArgumentException("null SQL name for " + obj);
        }
        if (this.views.containsKey(obj.getSQLName())) {
            throw new IllegalStateException("2 views named " + obj.getSQLName() + ": " + this.views.get(obj.getSQLName()) + " " + obj);
        }
        this.views.put(obj.getSQLName(), obj);
    }

    public void select(int id) {
        final SQLRow row = this.getTable().getRow(id);
        SwingThreadUtils.invoke(new Runnable(){

            @Override
            public void run() {
                SQLRowView.this.select(row);
            }
        });
    }

    public void select(SQLRowAccessor r) {
        this.setFilling(true);
        try {
            if (r == null) {
                this.setSelectedID(-1);
                for (SQLRowItemView view : this.getViewsFast()) {
                    view.resetValue();
                }
            } else {
                if (!this.getTable().equals(r.getTable())) {
                    throw new IllegalArgumentException("r is not of table " + this.getTable() + " : " + r);
                }
                if (r.getID() != -1) {
                    this.setSelectedID(r.getID());
                }
                for (SQLRowItemView view : this.getViewsFast()) {
                    view.show(r);
                }
            }
        }
        finally {
            this.setFilling(false);
        }
    }

    public final void detach() {
        this.setSelectedID(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws SQLException {
        SQLRowView sQLRowView = this;
        synchronized (sQLRowView) {
            this.updating = true;
        }
        this.update(this.getSelectedID());
        sQLRowView = this;
        synchronized (sQLRowView) {
            this.updating = false;
        }
    }

    private void update(int id) throws SQLException {
        if (id == this.getTable().getUndefinedID()) {
            throw new IllegalArgumentException("can't update undefined");
        }
        if (id == -1) {
            throw new IllegalArgumentException("NONEXISTANT_ID");
        }
        Log.get().fine("updating " + this.getTable() + " " + id);
        SQLRowValues vals = new SQLRowValues(this.getTable());
        for (SQLRowItemView view : this.getViewsFast()) {
            view.update(vals);
        }
        vals.update(id);
    }

    public SQLRow insert() throws SQLException {
        return this.fillVals().insert();
    }

    private SQLRowValues fillVals() {
        SQLRowValues vals = new SQLRowValues(this.getTable());
        for (SQLRowItemView view : this.getViewsFast()) {
            view.insert(vals);
        }
        return vals;
    }

    public SQLRow insert(SQLRow order) throws SQLException {
        SQLRowValues vals = this.fillVals();
        vals.setOrder(order, true);
        return vals.insertVerbatim();
    }

    public SQLTable getTable() {
        return this.table;
    }

    public Set<SQLRowItemView> getViews() {
        return new HashSet<SQLRowItemView>(this.getViewsFast());
    }

    private final Collection<SQLRowItemView> getViewsFast() {
        return this.views.values();
    }

    public String toString() {
        return this.getClass() + " with " + this.getViewsFast();
    }

    public SQLRowItemView getView(String name) {
        return this.views.get(name);
    }

    public SQLRowItemView getView(Component comp) {
        for (SQLRowItemView view : this.views.values()) {
            if (!SwingUtilities.isDescendingFrom(comp, view.getComp())) continue;
            return view;
        }
        return null;
    }

    @Override
    public Collection<SQLField> getAllFields() {
        HashSet<SQLField> res = new HashSet<SQLField>();
        for (SQLRowItemView view : this.getViewsFast()) {
            if (view.getField() == null) continue;
            res.add(view.getField());
        }
        return res;
    }

    private void setSelectedID(int selectedID) {
        this.selectedID = selectedID;
        this.supp.firePropertyChange("selectedID", null, (Object)this.selectedID);
    }

    public final int getSelectedID() {
        return this.selectedID;
    }

    public final boolean existsInDB() {
        return this.getSelectedID() != -1;
    }

    private final void setFilling(boolean filling) {
        this.filling = filling;
        this.supp.firePropertyChange("filling", null, (Object)this.filling);
    }

    public final void addListener(PropertyChangeListener l, String name) {
        this.supp.addPropertyChangeListener(name, l);
    }

    public final void rmListener(PropertyChangeListener l, String name) {
        this.supp.removePropertyChangeListener(name, l);
    }
}

