/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.TransfFieldExpander;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.IFieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.FilteredFillSQLRequest;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.cc.ITransformer;

public final class ComboSQLRequest
extends FilteredFillSQLRequest {
    private static final SQLCache<CacheKey, List<IComboSelectionItem>> cache = new SQLCache(60, -1, "items of " + ComboSQLRequest.class);
    private static String SEP_FIELD;
    private final List<SQLField> comboFields;
    private final TransfFieldExpander exp;
    private String fieldSeparator = SEP_FIELD;
    private String undefLabel;
    private IClosure<IComboSelectionItem> customizeItem;
    private List<Path> order;

    static {
        ComboSQLRequest.setDefaultFieldSeparator(" | ");
    }

    public static void setDefaultFieldSeparator(String separator) {
        SEP_FIELD = separator;
    }

    public ComboSQLRequest(SQLTable table, List<String> l) {
        this(table, l, null);
    }

    public ComboSQLRequest(SQLTable table, List<String> l, Where where) {
        super(table, where);
        this.undefLabel = null;
        this.customizeItem = null;
        this.order = null;
        this.exp = new TransfFieldExpander(new ITransformer<SQLField, List<SQLField>>(){

            @Override
            public List<SQLField> transformChecked(SQLField fk) {
                SQLTable foreignTable = fk.getDBSystemRoot().getGraph().getForeignTable(fk);
                return Configuration.getInstance().getDirectory().getElement(foreignTable).getComboRequest().getFields();
            }
        });
        this.comboFields = new ArrayList<SQLField>();
        for (String fName : l) {
            this.addItemToCombo(fName);
        }
    }

    public ComboSQLRequest(ComboSQLRequest c) {
        super(c);
        this.exp = new TransfFieldExpander(c.exp);
        this.comboFields = new ArrayList<SQLField>(c.comboFields);
        this.order = c.order == null ? null : new ArrayList<Path>(c.order);
    }

    private void addItemToCombo(String field) {
        this.comboFields.add(this.getPrimaryTable().getField(field));
    }

    public final void setUndefLabel(String undefLabel) {
        this.undefLabel = undefLabel;
    }

    public final String getUndefLabel() {
        return this.undefLabel;
    }

    public final IComboSelectionItem getComboItem(int id) {
        SQLRowValues res = this.getValues(id);
        return res == null ? null : this.createItem(res);
    }

    public final List<IComboSelectionItem> getComboItems() {
        if (this.comboFields.isEmpty()) {
            throw new IllegalStateException("La liste des items listitems est vide!! Ils faut utiliser addComboItem...");
        }
        SQLRowValuesListFetcher comboSelect = this.getFetcher(null).freeze();
        CacheKey cacheKey = new CacheKey(comboSelect, this.fieldSeparator, this.undefLabel, this.customizeItem);
        CacheResult l = cache.check(cacheKey);
        if (l.getState() == CacheResult.State.INTERRUPTED) {
            throw new RTInterruptedException("interrupted while waiting for the cache");
        }
        if (l.getState() == CacheResult.State.VALID) {
            return (List)l.getRes();
        }
        try {
            ArrayList<IComboSelectionItem> result = new ArrayList<IComboSelectionItem>();
            for (SQLRowValues vals : comboSelect.fetch()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new RTInterruptedException("interrupted in fill");
                }
                result.add(this.createItem(vals));
            }
            cache.put(cacheKey, result, this.getTables());
            return result;
        }
        catch (RuntimeException exn) {
            cache.removeRunning(cacheKey);
            throw exn;
        }
    }

    @Override
    protected final SQLSelect transformSelect(SQLSelect sel) {
        sel.setExcludeUndefined(this.undefLabel == null, this.getPrimaryTable());
        return super.transformSelect(sel);
    }

    @Override
    protected final List<Path> getOrder() {
        if (this.order != null) {
            return this.order;
        }
        List<Tuple2<Path, List<FieldPath>>> expandGroupBy = this.getShowAs().expandGroupBy((List<? extends IFieldPath>)this.getFields());
        ArrayList<Path> res = new ArrayList<Path>(expandGroupBy.size());
        for (Tuple2<Path, List<FieldPath>> ancestor : expandGroupBy) {
            res.add(0, ancestor.get0());
        }
        return res;
    }

    private final IComboSelectionItem createItem(final SQLRowValues rs) {
        String desc = this.undefLabel != null && rs.getID() == this.getPrimaryTable().getUndefinedID() ? this.undefLabel : CollectionUtils.join(this.exp.expandGroupBy((List<? extends IFieldPath>)this.getFields()), " \u25c4 ", new ITransformer<Tuple2<Path, List<FieldPath>>, Object>(){

            @Override
            public Object transformChecked(Tuple2<Path, List<FieldPath>> ancestorFields) {
                List filtered = CollectionUtils.transformAndFilter((Collection)ancestorFields.get1(), new ITransformer<FieldPath, String>(){

                    @Override
                    public String transformChecked(FieldPath input) {
                        return ComboSQLRequest.getFinalValueOf(input, rs);
                    }
                }, IPredicate.notNullPredicate(), new ArrayList());
                return CollectionUtils.join(filtered, ComboSQLRequest.this.fieldSeparator);
            }
        });
        IComboSelectionItem res = new IComboSelectionItem(rs.getID(), desc);
        if (this.customizeItem != null) {
            this.customizeItem.executeChecked(res);
        }
        return res;
    }

    @Override
    protected final TransfFieldExpander getShowAs() {
        return this.exp;
    }

    protected static String getFinalValueOf(FieldPath element, SQLRowValues rs) {
        String result = element.getString(rs);
        return result;
    }

    public final List<SQLField> getFields() {
        return this.comboFields;
    }

    public final void setFieldSeparator(String string) {
        this.fieldSeparator = string;
    }

    public String getSeparatorsChars() {
        return " \u25c4 " + this.fieldSeparator;
    }

    private static final class CacheKey
    extends Tuple3<SQLRowValuesListFetcher, IClosure<IComboSelectionItem>, String> {
        public CacheKey(SQLRowValuesListFetcher a, String fieldSeparator, String undefLabel, IClosure<IComboSelectionItem> c) {
            super(a, c, String.valueOf(fieldSeparator) + undefLabel);
        }
    }
}

