/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DirectedEdge;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.xml.JDOMUtils;

public class Link
extends DirectedEdge<SQLTable> {
    private final List<SQLField> cols;
    private final List<String> colsNames;
    private final List<SQLField> refCols;
    private final List<String> refColsNames;
    private final String name;

    public Link(List<SQLField> keys, List<SQLField> referredCols, String foreignKeyName) {
        super(keys.get(0).getTable(), referredCols.get(0).getTable());
        if (keys.size() != referredCols.size()) {
            throw new IllegalArgumentException("size mismatch: " + keys + " != " + referredCols);
        }
        this.cols = new ArrayList<SQLField>(keys);
        this.colsNames = new ArrayList<String>(this.cols.size());
        for (SQLField f : this.cols) {
            this.colsNames.add(f.getName());
        }
        this.refCols = new ArrayList<SQLField>(referredCols);
        this.refColsNames = new ArrayList<String>(this.refCols.size());
        for (SQLField f : this.refCols) {
            this.refColsNames.add(f.getName());
        }
        this.name = foreignKeyName;
    }

    public final List<SQLField> getFields() {
        return this.cols;
    }

    public final SQLField getSingleField() {
        return CollectionUtils.getSole(this.cols);
    }

    public final SQLField getLabel() {
        if (this.cols.size() == 1) {
            return this.cols.get(0);
        }
        throw new IllegalStateException(this + " has more than 1 foreign column: " + this.getFields());
    }

    public List<SQLField> getRefFields() {
        return this.refCols;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "<" + this.getFields() + " -> " + this.getTarget() + (this.getName() != null ? " '" + this.getName() + "'" : "") + ">";
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Link)) {
            return false;
        }
        Link o = (Link)other;
        return this.getFields().equals(o.getFields()) && this.getRefFields().equals(o.getRefFields());
    }

    @Override
    public int hashCode() {
        return this.getFields().hashCode() + this.getRefFields().hashCode();
    }

    void toXML(PrintWriter pWriter) {
        pWriter.print("  <link to=\"" + JDOMUtils.OUTPUTTER.escapeAttributeEntities(((SQLTable)this.getTarget()).getSQLName().toString()) + "\" ");
        if (this.getName() != null) {
            pWriter.print("name=\"" + JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getName()) + "\" ");
        }
        if (this.getFields().size() == 1) {
            this.toXML(pWriter, 0);
            pWriter.println("/>");
        } else {
            pWriter.println(">");
            int i = 0;
            while (i < this.getFields().size()) {
                pWriter.print("    <l ");
                this.toXML(pWriter, i);
                pWriter.println("/>");
                ++i;
            }
            pWriter.println("  </link>");
        }
    }

    private void toXML(PrintWriter pWriter, int i) {
        pWriter.print("col=\"");
        pWriter.print(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getFields().get(i).getName()));
        pWriter.print("\" refCol=\"");
        pWriter.print(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getRefFields().get(i).getName()));
        pWriter.print("\"");
    }

    static Link fromXML(SQLTable t, Element linkElem) {
        SQLName to = SQLName.parse(linkElem.getAttributeValue("to"));
        SQLTable foreignTable = t.getDBSystemRoot().getDesc(to, SQLTable.class);
        String linkName = linkElem.getAttributeValue("name");
        List lElems = linkElem.getAttribute("col") != null ? Collections.singletonList(linkElem) : linkElem.getChildren("l");
        ArrayList<SQLField> cols = new ArrayList<SQLField>();
        ArrayList<SQLField> refcols = new ArrayList<SQLField>();
        for (Element l : lElems) {
            cols.add(t.getField(l.getAttributeValue("col")));
            refcols.add(foreignTable.getField(l.getAttributeValue("refCol")));
        }
        return new Link(cols, refcols, linkName);
    }
}

