/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.MySQLBase;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

class SQLSyntaxMySQL
extends SQLSyntax {
    SQLSyntaxMySQL() {
        super(SQLSystem.MYSQL);
        this.typeNames.putAll(Boolean.class, "boolean", "bool", "bit");
        this.typeNames.putAll(Integer.class, "integer", "int");
        this.typeNames.putAll(Long.class, "bigint");
        this.typeNames.putAll(BigInteger.class, "bigint");
        this.typeNames.putAll(BigDecimal.class, "decimal", "numeric");
        this.typeNames.putAll(Float.class, "float");
        this.typeNames.putAll(Double.class, "double precision", "real");
        this.typeNames.putAll(Timestamp.class, "timestamp");
        this.typeNames.putAll(Date.class, "time");
        this.typeNames.putAll(Blob.class, "blob", "tinyblob", "mediumblob", "longblob", "varbinary", "binary");
        this.typeNames.putAll(Clob.class, "text", "tinytext", "mediumtext", "longtext", "varchar", "char");
        this.typeNames.putAll(String.class, "varchar", "char");
    }

    @Override
    public String getIDType() {
        return " int";
    }

    @Override
    public String getAuto() {
        return String.valueOf(this.getIDType()) + " AUTO_INCREMENT NOT NULL";
    }

    @Override
    public String getCreateTableSuffix() {
        return " ENGINE = InnoDB ";
    }

    @Override
    public SQLBase createBase(SQLServer server, String name, String login, String pass, IClosure<SQLDataSource> dsInit) {
        return new MySQLBase(server, name, login, pass, dsInit);
    }

    @Override
    public String getNullIsDataComparison(String x, boolean eq, String y) {
        String nullSafe = String.valueOf(x) + " <=> " + y;
        if (eq) {
            return nullSafe;
        }
        return "NOT (" + nullSafe + ")";
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        return "SELECT null as \"schema\", ROUTINE_NAME as \"name\", ROUTINE_DEFINITION as \"src\" FROM \"information_schema\".ROUTINES where ROUTINE_CATALOG is null and ROUTINE_SCHEMA = '" + b.getMDName() + "'";
    }

    @Override
    public String getTriggerQuery(SQLBase b, Set<String> schemas, Set<String> tables) {
        return "SELECT \"TRIGGER_NAME\", null as \"TABLE_SCHEMA\", EVENT_OBJECT_TABLE as \"TABLE_NAME\", ACTION_STATEMENT as \"ACTION\", null as \"SQL\" from INFORMATION_SCHEMA.TRIGGERS where " + this.getInfoSchemaWhere("\"EVENT_OBJECT_CATALOG\"", b, "EVENT_OBJECT_SCHEMA", schemas, "EVENT_OBJECT_TABLE", tables);
    }

    private final String getInfoSchemaWhere(String catCol, SQLBase b, String schemaCol, Set<String> schemas, String tableCol, Set<String> tables) {
        String tableWhere = tables == null ? "" : " and " + tableCol + " in (" + SQLSyntaxMySQL.quoteStrings(b, tables) + ")";
        return String.valueOf(catCol) + " is null and " + schemaCol + " = '" + b.getMDName() + "' " + tableWhere;
    }

    @Override
    public String getColumnsQuery(SQLBase b, Set<String> schemas, Set<String> tables) {
        return "SELECT null as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(0) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(1) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(2) + "\" , \"CHARACTER_SET_NAME\", \"COLLATION_NAME\" from INFORMATION_SCHEMA.\"COLUMNS\" where " + this.getInfoSchemaWhere("\"TABLE_CATALOG\"", b, "TABLE_SCHEMA", schemas, "TABLE_NAME", tables);
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, Set<String> schemas, Set<String> tables) throws SQLException {
        String sel = "SELECT null as \"TABLE_SCHEMA\", c.\"TABLE_NAME\", c.\"CONSTRAINT_NAME\", tc.\"CONSTRAINT_TYPE\", \"COLUMN_NAME\", c.\"ORDINAL_POSITION\"\n FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE c\nJOIN (SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS T where " + this.getInfoSchemaWhere("\"CONSTRAINT_CATALOG\"", b, "TABLE_SCHEMA", schemas, "TABLE_NAME", tables) + ") tc on tc.\"TABLE_SCHEMA\" = c.\"TABLE_SCHEMA\" and tc.\"TABLE_NAME\"=c.\"TABLE_NAME\" and tc.\"CONSTRAINT_NAME\"=c.\"CONSTRAINT_NAME\"\n" + " where \"CONSTRAINT_TYPE\" not in ('FOREIGN KEY', 'PRIMARY KEY') and\n" + this.getInfoSchemaWhere("c.\"TABLE_CATALOG\"", b, "c.TABLE_SCHEMA", schemas, "c.TABLE_NAME", tables) + "order by c.\"TABLE_SCHEMA\", c.\"TABLE_NAME\", c.\"CONSTRAINT_NAME\", c.\"ORDINAL_POSITION\"";
        List res = (List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
        SQLSyntaxMySQL.mergeColumnNames(res);
        return res;
    }

    static void mergeColumnNames(List<Map<String, Object>> res) {
        Iterator<Map<String, Object>> listIter = res.iterator();
        ArrayList<String> l = null;
        while (listIter.hasNext()) {
            Map<String, Object> m = listIter.next();
            int pos = ((Number)m.remove("ORDINAL_POSITION")).intValue();
            if (pos == 1) {
                l = new ArrayList<String>();
                m.put("COLUMN_NAMES", l);
            } else {
                listIter.remove();
            }
            l.add((String)m.remove("COLUMN_NAME"));
        }
    }

    @Override
    public String getUpdate(final SQLTable t, List<String> tables, Map<String, String> setPart) {
        ArrayList<String> l = new ArrayList<String>(tables);
        l.add(0, t.getSQLName().quote());
        return String.valueOf(CollectionUtils.join(l, ", ")) + "\nSET " + CollectionUtils.join(setPart.entrySet(), ",\n", new ITransformer<Map.Entry<String, String>, String>(){

            @Override
            public String transformChecked(Map.Entry<String, String> input) {
                return String.valueOf(t.getField(input.getKey()).getSQLName(t).quote()) + " = " + input.getValue();
            }
        });
    }
}

