/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;

class SQLSyntaxH2
extends SQLSyntax {
    SQLSyntaxH2() {
        super(SQLSystem.H2);
        this.typeNames.putAll(Boolean.class, "boolean", "bool", "bit");
        this.typeNames.putAll(Integer.class, "integer", "int", "int4", "mediumint");
        this.typeNames.putAll(Byte.class, "tinyint");
        this.typeNames.putAll(Short.class, "smallint", "int2");
        this.typeNames.putAll(Long.class, "bigint", "int8");
        this.typeNames.putAll(BigDecimal.class, "decimal", "numeric", "number");
        this.typeNames.putAll(Float.class, "real");
        this.typeNames.putAll(Double.class, "double precision", "float", "float4", "float8");
        this.typeNames.putAll(Timestamp.class, "timestamp", "smalldatetime", "datetime");
        this.typeNames.putAll(Date.class, "date");
        this.typeNames.putAll(Blob.class, "blob", "tinyblob", "mediumblob", "longblob", "image", "bytea", "raw", "varbinary", "longvarbinary", "binary");
        this.typeNames.putAll(Clob.class, "clob", "text", "tinytext", "mediumtext", "longtext");
        this.typeNames.putAll(String.class, "varchar", "longvarchar", "char", "character", "CHARACTER VARYING");
    }

    @Override
    public String getIDType() {
        return " int";
    }

    @Override
    public String getAuto() {
        return " IDENTITY";
    }

    @Override
    public boolean supportMultiAlterClause() {
        return false;
    }

    @Override
    public String getNullIsDataComparison(String x, boolean eq, String y) {
        String nullSafe = String.valueOf(x) + " = " + y + " or ( " + x + " is null and " + y + " is null)";
        if (eq) {
            return nullSafe;
        }
        return String.valueOf(x) + " <> " + y + " or (" + x + " is null and " + y + " is not null) " + " or (" + x + " is not null and " + y + " is null) ";
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        return null;
    }

    @Override
    public String getTriggerQuery(SQLBase b, Set<String> schemas, Set<String> tables) {
        return "SELECT \"TRIGGER_NAME\", \"TABLE_SCHEMA\", \"TABLE_NAME\", \"JAVA_CLASS\" as \"ACTION\", \"SQL\" from INFORMATION_SCHEMA.TRIGGERS where " + this.getInfoSchemaWhere(b, schemas, tables);
    }

    private final String getInfoSchemaWhere(SQLBase b, Set<String> schemas, Set<String> tables) {
        String tableWhere = tables == null ? "" : " and \"TABLE_NAME\" in (" + SQLSyntaxH2.quoteStrings(b, tables) + ")";
        return "\"TABLE_CATALOG\" = '" + b.getMDName() + "' and \"TABLE_SCHEMA\" in (" + SQLSyntaxH2.quoteStrings(b, schemas) + ") " + tableWhere;
    }

    @Override
    public String getColumnsQuery(SQLBase b, Set<String> schemas, Set<String> tables) {
        return "SELECT \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(0) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(1) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(2) + "\" , \"CHARACTER_SET_NAME\", \"COLLATION_NAME\" from INFORMATION_SCHEMA.\"COLUMNS\" where " + this.getInfoSchemaWhere(b, schemas, tables);
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, Set<String> schemas, Set<String> tables) throws SQLException {
        String sel = "SELECT \"TABLE_SCHEMA\", \"TABLE_NAME\", \"CONSTRAINT_NAME\", \ncase \"CONSTRAINT_TYPE\"  when 'REFERENTIAL' then 'FOREIGN KEY' else \"CONSTRAINT_TYPE\" end as \"CONSTRAINT_TYPE\", \"COLUMN_LIST\"\nFROM INFORMATION_SCHEMA.CONSTRAINTS where \"CONSTRAINT_TYPE\" not in ('REFERENTIAL', 'PRIMARY KEY') and\n" + this.getInfoSchemaWhere(b, schemas, tables);
        List res = (List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
        for (Map m : res) {
            m.put("COLUMN_NAMES", new ArrayList<String>(SQLRow.toList((String)m.remove("COLUMN_LIST"))));
        }
        return res;
    }
}

