/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.openconcerto.sql.model.SQLDataSource;

public class SQLRequestLog {
    private static List<SQLRequestLog> list = new ArrayList<SQLRequestLog>(500);
    private static boolean enabled;
    private String query;
    private String comment;
    private long startAsMs;
    private long durationSQLNano;
    private long durationTotalNano;
    private String stack;
    private boolean inSwing;
    private int connectionId;
    private boolean forShare;
    private String threadId;
    private static List<ChangeListener> listeners;
    private static JLabel textInfo;
    private static final SimpleDateFormat sdt;
    private static final DecimalFormat dformat;

    static {
        listeners = new ArrayList<ChangeListener>(2);
        textInfo = new JLabel("Total: ");
        sdt = new SimpleDateFormat("HH:MM:ss.SS");
        dformat = new DecimalFormat("##0.00");
    }

    public SQLRequestLog(String query, String comment, int connectionId, long starAtMs, long durationSQLNano, long durationTotalNano, String ex, boolean inSwing) {
        this.query = query;
        this.comment = comment;
        this.connectionId = connectionId;
        this.startAsMs = starAtMs;
        this.durationSQLNano = durationSQLNano;
        this.durationTotalNano = durationTotalNano;
        this.stack = ex;
        this.inSwing = inSwing;
        this.forShare = query.contains("FOR SHARE");
        if (this.forShare) {
            this.comment = "Utilise FOR SHARE. " + comment;
        }
        this.threadId = "[" + Thread.currentThread().getId() + "] " + Thread.currentThread().getName();
    }

    public static void log(String query, String comment, int hashCode, long starAtMs, long durationSQLNano, long durationTotalNano) {
        if (enabled) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(b));
            String ex = b.toString();
            list.add(new SQLRequestLog(query, comment, hashCode, starAtMs, durationSQLNano, durationTotalNano, ex, SwingUtilities.isEventDispatchThread()));
            SQLRequestLog.fireEvent();
        }
    }

    public static void log(String query, String comment, long starAtMs, long durationNano) {
        SQLRequestLog.log(query, comment, 0, starAtMs, durationNano, durationNano);
    }

    public static void log(String query, String comment, SQLDataSource.QueryInfo info, long starAtMs, long durationSQLNano, long durationTotalNano) {
        SQLRequestLog.log(query, comment, System.identityHashCode(info.getConnection()), starAtMs, durationSQLNano, durationTotalNano);
    }

    private static void fireEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int stop = listeners.size();
                int i = 0;
                while (i < stop) {
                    ((ChangeListener)listeners.get(i)).stateChanged(null);
                    ++i;
                }
                long totalMs = SQLRequestLog.getTotalMs();
                long totalSQLMs = SQLRequestLog.getTotalSQLMs();
                textInfo.setText("Total: " + totalMs + " ms,  Swing: " + SQLRequestLog.getTotalSwing() + " ms, SQL: " + totalSQLMs + " ms, traitement: " + (totalMs - totalSQLMs) + " ms , " + SQLRequestLog.getNbConnections() + " connexions, " + SQLRequestLog.getNbThread() + " threads");
            }
        });
    }

    protected static int getNbConnections() {
        HashSet<Integer> s = new HashSet<Integer>();
        int stop = list.size();
        int i = 0;
        while (i < stop) {
            SQLRequestLog l = list.get(i);
            if (l.getConnectionId() > 0) {
                s.add(l.getConnectionId());
            }
            ++i;
        }
        return s.size();
    }

    protected static int getNbThread() {
        HashSet<String> s = new HashSet<String>();
        int stop = list.size();
        int i = 0;
        while (i < stop) {
            SQLRequestLog l = list.get(i);
            s.add(l.getThreadId());
            ++i;
        }
        return s.size();
    }

    protected static long getTotalMs() {
        int stop = list.size();
        long t = 0L;
        int i = 0;
        while (i < stop) {
            t += SQLRequestLog.list.get((int)i).durationTotalNano / 1000L;
            ++i;
        }
        return t / 1000L;
    }

    protected static long getTotalSQLMs() {
        int stop = list.size();
        long t = 0L;
        int i = 0;
        while (i < stop) {
            t += SQLRequestLog.list.get((int)i).durationSQLNano / 1000L;
            ++i;
        }
        return t / 1000L;
    }

    protected static long getTotalSwing() {
        int stop = list.size();
        long t = 0L;
        int i = 0;
        while (i < stop) {
            SQLRequestLog requestLog = list.get(i);
            if (requestLog.isInSwing()) {
                t += requestLog.durationTotalNano / 1000L;
            }
            ++i;
        }
        return t / 1000L;
    }

    public boolean isInSwing() {
        return this.inSwing;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public String getThreadId() {
        return this.threadId;
    }
}

