/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.ui.FormLayouter;

public abstract class UISQLComponent
extends BaseSQLComponent {
    private static final String REQ_SUFFIX = System.getProperty("org.openconcerto.sql.requiredSuffix", " *");
    private FormLayouter autoLayouter;
    private JPanel currentPanel;
    private JTabbedPane tabbedPane;
    private final int width;
    private final int def;

    public UISQLComponent(SQLElement element) {
        this(element, 2);
    }

    public UISQLComponent(SQLElement element, int width) {
        this(element, width, 0);
    }

    public UISQLComponent(SQLElement element, int width, int def) {
        super(element);
        this.width = width;
        this.def = def;
        this.tabbedPane = null;
        this.currentPanel = this;
        this.autoLayouter = null;
    }

    @Override
    protected void addToUI(SQLRowItemView obj, String where) {
        String desc = UISQLComponent.getDesc(obj);
        if (this.getRequired().contains(obj)) {
            desc = String.valueOf(desc) + REQ_SUFFIX;
        }
        if (where == null) {
            where = this.getDefaultWhere(obj);
        }
        if (where == null) {
            this.getLayouter().add(desc, obj.getComp());
        } else if (where.equals("bordered")) {
            this.getLayouter().addBordered(desc, obj.getComp(), 0);
        } else if (where.equals("left")) {
            this.getLayouter().newLine();
            this.getLayouter().add(desc, obj.getComp(), this.getLayouter().getWidth() / 2);
        } else if (where.equals("right")) {
            this.getLayouter().add(desc, obj.getComp(), (this.getLayouter().getWidth() + 1) / 2);
        } else {
            int aWidth = Integer.parseInt(where);
            this.getLayouter().add(desc, obj.getComp(), aWidth);
        }
    }

    private String getDefaultWhere(SQLRowItemView obj) {
        if (this.getElement().getPrivateForeignFields().contains(obj.getField().getName())) {
            return "bordered";
        }
        return null;
    }

    private void setLayouter(int w, int d) {
        this.autoLayouter = new FormLayouter(this.currentPanel, w, d);
        this.setAdditionalFieldsPanel(this.autoLayouter);
    }

    protected final FormLayouter getLayouter() {
        if (this.autoLayouter == null) {
            this.setLayouter(this.width, this.def);
        }
        return this.autoLayouter;
    }
}

