/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.DefaultElementSQLObject;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.request.MutableRowItemView;
import org.openconcerto.sql.request.RowNotFound;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.request.SQLRowView;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLSearchableTextCombo;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.sqlobject.itemview.SimpleRowItemView;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.ui.DisplayabilityListener;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.text.TextBehaviour;
import org.openconcerto.ui.component.text.TextComponentUtils;
import org.openconcerto.ui.coreanimation.Animator;
import org.openconcerto.ui.valuewrapper.ValueWrapperFactory;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;

public abstract class BaseSQLComponent
extends SQLComponent
implements Scrollable {
    private final SQLRowView requete;
    private final Set<SQLRowItemView> required;
    private final Set<String> requiredNames;
    private final List<ValidListener> listeners;
    private boolean editable;
    private boolean alwaysEditable;
    private final Set<SQLField> hide;
    private String invalidityCause;
    private FormLayouter additionalFieldsPanel;

    public BaseSQLComponent(SQLElement element) {
        super(element);
        this.setOpaque(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BaseSQLComponent.this.requestFocusInWindow();
            }
        });
        this.required = new HashSet<SQLRowItemView>();
        this.requiredNames = this.createRequiredNames();
        this.listeners = new ArrayList<ValidListener>();
        this.hide = new HashSet<SQLField>();
        this.editable = true;
        this.setNonExistantEditable(false);
        this.requete = new SQLRowView(this.getTable());
        this.invalidityCause = "";
    }

    private final SQLRowView getRequest() {
        return this.requete;
    }

    private SQLField getField(String field) {
        return this.getTable().getField(field);
    }

    public Component addView(String field) {
        return this.addView(field, null);
    }

    public Component addView(String field, String spec) {
        return this.addViewJComponent(field, spec);
    }

    private Component addViewJComponent(String field, Object spec) {
        if (this.getElement().getPrivateElement(field) != null) {
            SQLComponent comp = this.getElement().getPrivateElement(field).createComponent();
            SpecParser parser = SpecParser.create(spec);
            DefaultElementSQLObject dobj = new DefaultElementSQLObject(this, comp);
            dobj.setDecorated(parser.isDecorated());
            dobj.showSeparator(parser.showSeparator());
            return this.addView(dobj, field, (Object)parser);
        }
        if (this.getField(field).isKey()) {
            return this.addView(new ElementComboBox(), field, spec);
        }
        SQLType type = this.getField(field).getType();
        Object comp = Boolean.class.isAssignableFrom(type.getJavaType()) ? new JCheckBox(" ") : (Date.class.isAssignableFrom(type.getJavaType()) ? new JDate() : (String.class.isAssignableFrom(type.getJavaType()) && type.getSize() >= 512 ? new SQLSearchableTextCombo(ComboLockedMode.UNLOCKED, true) : new SQLTextCombo()));
        return this.addView((JComponent)comp, field, spec);
    }

    public final void addSQLObject(JComponent obj, String field) {
        this.addSQLObject(obj, field, null);
    }

    public Component addSQLObject(JComponent obj, String field, Object spec) {
        return this.addView(obj, field, spec);
    }

    public void addRequiredSQLObject(JComponent obj, String field, Object spec) {
        this.addSQLObject(obj, field, "required;" + spec);
    }

    public void addRequiredSQLObject(JComponent obj, String field) {
        this.addSQLObject(obj, field, "required");
    }

    public Component addView(JComponent comp, String fields) {
        return this.addView(comp, fields, null);
    }

    public Component addView(JComponent comp, String fields, Object specObj) {
        SimpleRowItemView<?> rowItemView;
        if (comp instanceof MutableRowItemView) {
            rowItemView = (SimpleRowItemView<?>)((Object)comp);
        } else {
            SQLField field = this.getField(SQLRow.toList(fields).get(0));
            rowItemView = BaseSQLComponent.createRowItemView(comp, field);
        }
        return this.addView(rowItemView, fields, specObj);
    }

    public static SimpleRowItemView<?> createRowItemView(JComponent comp, SQLField field) {
        if (comp == null) {
            throw new NullPointerException("comp for " + field + " is null");
        }
        return BaseSQLComponent.createRowItemView(comp, field.getType().getJavaType());
    }

    private static <T> SimpleRowItemView<T> createRowItemView(JComponent comp, Class<T> javaType) {
        return new SimpleRowItemView<T>(ValueWrapperFactory.create(comp, javaType));
    }

    public Component addView(MutableRowItemView rowItemView, String fields, Object specObj) {
        List<String> fieldListS = SQLRow.toList(fields);
        HashSet<SQLField> fieldList = new HashSet<SQLField>(fieldListS.size());
        for (String fieldName : fieldListS) {
            fieldList.add(this.getField(fieldName));
        }
        String sqlName = fields;
        rowItemView.init(sqlName, fieldList);
        rowItemView.setDescription(this.getLabelFor(sqlName));
        return this.addInitedView(rowItemView, specObj);
    }

    public Component addInitedView(SQLRowItemView v, Object specObj) {
        JTextComponent textComp;
        SpecParser spec = SpecParser.create(specObj);
        String fieldName = v.getField().getName();
        if (spec.isRequired() || fieldName.equals(this.getElement().getParentForeignField()) || this.getRequiredNames() == null || this.getRequiredNames().contains(v.getSQLName())) {
            this.required.add(v);
            if (v instanceof ElementSQLObject) {
                ((ElementSQLObject)v).setRequired(true);
            }
        }
        this.getRequest().add(v);
        if (!this.hide.contains(v.getField())) {
            if (spec.isAdditional()) {
                if (this.additionalFieldsPanel == null) {
                    Log.get().warning("No additionalFieldsPanel for " + v.getField() + " : " + v);
                } else {
                    this.additionalFieldsPanel.add(BaseSQLComponent.getDesc(v), v.getComp());
                }
            } else {
                this.addToUI(v, spec.getWhere());
            }
        }
        if (this.dontEdit(v)) {
            v.setEditable(false);
        }
        if ((textComp = TextComponentUtils.getTextComp(v.getComp())) != null) {
            TextBehaviour.manage(textComp);
        }
        return v.getComp();
    }

    private boolean dontEdit(SQLRowItemView v) {
        String fieldName = v.getField().getName();
        return this.getElement().getReadOnlyFields().contains(fieldName) || this.getMode() != SQLComponent.Mode.INSERTION && this.getElement().getInsertOnlyFields().contains(fieldName);
    }

    @Override
    protected final void inited() {
        super.inited();
        for (Map.Entry<String, JComponent> e : this.getElement().getAdditionalFields().entrySet()) {
            SpecParser spec = new SpecParser(null, true);
            JComponent comp = e.getValue();
            if (comp == null) {
                this.addViewJComponent(e.getKey(), spec);
                continue;
            }
            this.addView(comp, e.getKey(), (Object)spec);
        }
        this.setChildrenEditable(this.isEditable());
        for (SQLRowItemView v : this.getRequest().getViews()) {
            v.addEmptyListener(new EmptyListener(){

                @Override
                public void emptyChange(EmptyObj src, boolean newValue) {
                    BaseSQLComponent.this.emptyOrValidChanged((SQLRowItemView)src);
                }
            });
            v.addValidListener(new ValidListener(){

                @Override
                public void validChange(ValidObject src, boolean newValue) {
                    BaseSQLComponent.this.emptyOrValidChanged((SQLRowItemView)src);
                }
            });
            this.updateAnimate(v);
        }
        this.addHierarchyListener(new DisplayabilityListener(){

            @Override
            protected void displayabilityChanged(Component c) {
                BaseSQLComponent.this.getRequest().activate(c.isDisplayable());
            }
        });
        this.getRequest().activate(this.isDisplayable());
        this.fireValidChange();
        this.initDone();
    }

    protected void initDone() {
    }

    private void updateAnimate(SQLRowItemView v) {
        if (v.getComp() != null) {
            Animator.getInstance().animate(v.getComp(), !this.isItemViewValid(v));
        }
    }

    protected void emptyOrValidChanged(SQLRowItemView v) {
        this.fireValidChange();
        this.updateAnimate(v);
    }

    protected void addToUI(SQLRowItemView v, String where) {
    }

    protected final void setAdditionalFieldsPanel(FormLayouter panel) {
        this.additionalFieldsPanel = panel;
    }

    public final SQLRowItemView getView(String name) {
        return this.getRequest().getView(name);
    }

    protected final SQLRowItemView getView(Component comp) {
        return this.getRequest().getView(comp);
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.listeners.add(l);
    }

    protected final synchronized void fireValidChange() {
        boolean validated = this.isValidated();
        for (ValidListener l : this.listeners) {
            l.validChange(this, validated);
        }
    }

    private boolean isItemViewValid(SQLRowItemView v) {
        return v.isValidated() && (!this.getRequired().contains(v) || !v.isEmpty());
    }

    @Override
    public synchronized boolean isValidated() {
        boolean res = true;
        ArrayList<String> pbs = new ArrayList<String>();
        for (SQLRowItemView obj : this.getRequest().getViews()) {
            if (!obj.isValidated()) {
                String explanation = "'" + BaseSQLComponent.getDesc(obj) + "' n'est pas valide";
                String txt = obj.getValidationText();
                if (txt != null) {
                    explanation = String.valueOf(explanation) + " (" + txt + ")";
                }
                pbs.add(explanation);
                res = false;
                continue;
            }
            if (!this.getRequired().contains(obj) || !obj.isEmpty()) continue;
            pbs.add("'" + BaseSQLComponent.getDesc(obj) + "' est vide");
            res = false;
        }
        this.invalidityCause = CollectionUtils.join(pbs, "\n");
        return res;
    }

    protected static final String getDesc(SQLRowItemView obj) {
        String desc = obj.getDescription();
        return desc == null ? obj.getSQLName() : desc;
    }

    @Override
    public String getValidationText() {
        return this.invalidityCause;
    }

    @Override
    public void setEditable(boolean b) {
        if (b != this.editable) {
            this.editable = b;
            this.setChildrenEditable(b);
        }
    }

    private final void setChildrenEditable(boolean b) {
        for (SQLRowItemView o : this.getRequest().getViews()) {
            if (this.dontEdit(o)) continue;
            o.setEditable(this.isEditable() && b);
        }
    }

    private final boolean isEditable() {
        return this.editable;
    }

    @Override
    public final void resetValue() {
        this.select(null);
    }

    @Override
    public final int insert() {
        return this.insert(null);
    }

    @Override
    public int insert(SQLRow order) {
        try {
            if (!UserRightsManager.getCurrentUserRights().canAdd(this.getTable())) {
                throw new SQLException("forbidden");
            }
            if (order == null) {
                return this.getRequest().insert().getID();
            }
            return this.getRequest().insert(order).getID();
        }
        catch (SQLException e) {
            ExceptionHandler.handle(this, "Impossible d'ins\u00e9rer", e);
            return -1;
        }
    }

    @Override
    public final void select(int id) {
        this.select(this.getTable().getRow(id));
    }

    @Override
    public void select(SQLRowAccessor r) {
        try {
            if (r != null && !UserRightsManager.getCurrentUserRights().canView(this.getTable())) {
                throw new IllegalStateException("forbidden");
            }
            this.getRequest().select(r);
            this.setChildrenEditable(this.isNonExistantEditable() || r != null && r.getID() != -1);
            if (r == null && this.isNonExistantEditable()) {
                this.selectDefaults();
            }
        }
        catch (RowNotFound e) {
            this.getTable().fireRowDeleted(e.getRow().getID());
            ExceptionHandler.handle(this, "La ligne n'est plus dans la base : " + e.getRow(), e);
        }
        catch (IllegalStateException e) {
            ExceptionHandler.handle(this, "Impossible de s\u00e9lectionner " + r, e);
        }
    }

    private final void selectDefaults() {
        SQLRowValues defaults = this.createDefaults();
        if (defaults != null && defaults.getFields().size() > 0) {
            this.getRequest().select(defaults);
        }
    }

    public final void addFillingListener(PropertyChangeListener l) {
        this.getRequest().addListener(l, "filling");
    }

    public final void rmFillingListener(PropertyChangeListener l) {
        this.getRequest().rmListener(l, "filling");
    }

    public final void addSelectionListener(PropertyChangeListener l) {
        this.getRequest().addListener(l, "selectedID");
    }

    @Override
    public void detach() {
        this.getRequest().detach();
    }

    @Override
    public int getSelectedID() {
        return this.getRequest().getSelectedID();
    }

    @Override
    public void update() {
        try {
            if (!UserRightsManager.getCurrentUserRights().canModify(this.getTable())) {
                throw new SQLException("forbidden");
            }
            this.getRequest().update();
        }
        catch (SQLException e) {
            ExceptionHandler.handle(this, "Impossible de mettre \u00e0 jour", e);
        }
    }

    @Override
    public void archive() {
        try {
            if (!UserRightsManager.getCurrentUserRights().canDelete(this.getTable())) {
                throw new SQLException("forbidden");
            }
            this.getElement().archive(this.getSelectedID());
        }
        catch (SQLException e) {
            ExceptionHandler.handle(this, "Impossible d'archiver " + this + ": ", e);
        }
    }

    protected final Set<SQLRowItemView> getRequired() {
        return this.required;
    }

    protected final Set<String> getRequiredNames() {
        return this.requiredNames;
    }

    protected Set<String> createRequiredNames() {
        return new HashSet<String>(Collections.singleton("DESIGNATION"));
    }

    @Override
    public String toString() {
        return this.getClass() + " on " + this.getTable() + " " + this.getSelectedID();
    }

    public final boolean isNonExistantEditable() {
        return this.alwaysEditable;
    }

    @Override
    public final void setNonExistantEditable(boolean alwaysEditable) {
        this.alwaysEditable = alwaysEditable;
    }

    public final String getLabelFor(String field) {
        return Configuration.getTranslator(this.getTable()).getDescFor(this.getTable(), field).getLabel();
    }

    public void doNotShow(SQLField f) {
        this.hide.add(f);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() >= this.getMinimumSize().height;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 15;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        double length = orientation == 1 ? visibleRect.getHeight() : visibleRect.getWidth();
        return (int)(length - 30.0);
    }

    private static interface Spec {
        public boolean isRequired();

        public String getWhere();

        public boolean isAdditional();
    }

    private static final class SpecParser
    implements Spec {
        private boolean isRequired;
        private String where;
        private boolean showSeparator = true;
        private boolean isDecorated = true;
        private final boolean isAdditional;

        public static SpecParser create(Object specObj) {
            SpecParser spec = specObj == null || specObj instanceof String ? new SpecParser((String)specObj) : (SpecParser)specObj;
            return spec;
        }

        public SpecParser(String spec) {
            this(spec, false);
        }

        public SpecParser(String spec, boolean isAdditional) {
            this.isAdditional = isAdditional;
            if (spec == null || spec.length() == 0) {
                this.isRequired = false;
                this.where = null;
            } else {
                String[] specs = spec.split(";");
                if (specs.length > 4) {
                    throw new IllegalArgumentException(spec);
                }
                int i = 0;
                while (i < specs.length) {
                    String sp = specs[i];
                    if (sp.equals("required")) {
                        this.isRequired = true;
                    } else if (sp.equals("notdecorated")) {
                        this.isDecorated = false;
                    } else if (sp.equals("noseparator")) {
                        this.showSeparator = false;
                    } else {
                        this.where = sp;
                    }
                    ++i;
                }
            }
        }

        public boolean showSeparator() {
            return this.showSeparator;
        }

        public boolean isDecorated() {
            return this.isDecorated;
        }

        @Override
        public final boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public final String getWhere() {
            return this.where;
        }

        @Override
        public final boolean isAdditional() {
            return this.isAdditional;
        }
    }
}

