/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.ui.preferences.TemplateProps;
import org.openconcerto.utils.StreamUtils;

public class TemplateNXProps
extends TemplateProps {
    private static final String societeBaseName = ((ComptaPropsConfiguration)Configuration.getInstance()).getSocieteBaseName();

    @Override
    protected String getPropsFileName() {
        File f = Configuration.getInstance().getConfDir();
        File f2 = new File(f, "Configuration" + File.separator + "Template.properties");
        if (!f2.exists()) {
            InputStream fConf = ComptaBasePropsConfiguration.getStreamStatic("/Configuration/Template.properties");
            if (fConf == null) {
                JOptionPane.showMessageDialog(null, "L'emplacement des mod\u00e9les n'est pas d\u00e9fini.");
            } else {
                try {
                    StreamUtils.copy(fConf, f2);
                    fConf.close();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "Impossible de copier le fichier de configuration de l'emplacement des mod\u00e9les\ndepuis le serveur, veuillez d\u00e9finir l'emplacement des mod\u00e9les manuellement.");
                    e.printStackTrace();
                }
            }
        }
        if (f2.exists()) {
            return f2.getAbsolutePath();
        }
        try {
            f2.getParentFile().mkdirs();
            f2.createNewFile();
        }
        catch (IOException e) {
            System.err.println(f2);
            e.printStackTrace();
        }
        return f2.getAbsolutePath();
    }

    @Override
    public String getPropertySuffix() {
        return societeBaseName;
    }

    @Override
    public String getDefaultStringValue() {
        Configuration conf = ComptaPropsConfiguration.getInstance();
        SQLRow rowSociete = ((ComptaPropsConfiguration)conf).getRowSociete();
        return String.valueOf(conf.getWD().getAbsolutePath()) + File.separator + rowSociete.getString("NOM") + "-" + rowSociete.getID();
    }

    public static synchronized TemplateProps getInstance() {
        if (instance == null) {
            instance = new TemplateNXProps();
        }
        return instance;
    }
}

