/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.core.sales.pos.io.DefaultTicketPrinter;

public class ESCSerialPrinter
extends DefaultTicketPrinter {
    protected List<String> strings = new ArrayList<String>();
    protected List<Integer> modes = new ArrayList<Integer>();
    private String port;

    public ESCSerialPrinter(String port) {
        this.port = port;
    }

    @Override
    public void addToBuffer(String t) {
        this.addToBuffer(t, 0);
    }

    @Override
    public void addToBuffer(String t, int mode) {
        this.strings.add(t);
        this.modes.add(mode);
    }

    @Override
    public void openDrawer() throws Exception {
        SerialPort serialPort = this.getSerialPort();
        OutputStream out = serialPort.getOutputStream();
        out.write(16);
        out.write(20);
        out.write(1);
        out.write(0);
        out.write(2);
        out.flush();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        out.write(16);
        out.write(20);
        out.write(1);
        out.write(1);
        out.write(2);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        out.flush();
        out.close();
        serialPort.close();
    }

    @Override
    public void printBuffer() throws Exception {
        System.out.println("Port " + this.port);
        SerialPort serialPort = this.getSerialPort();
        OutputStream out = serialPort.getOutputStream();
        out.write(27);
        out.write(64);
        out.write(27);
        out.write(82);
        out.write(1);
        int i = 0;
        while (i < this.strings.size()) {
            int c;
            int k;
            String string = this.strings.get(i);
            int mode = this.modes.get(i);
            if (mode == 10) {
                System.out.println("Barcode:" + string);
                out.write(29);
                out.write(72);
                out.write(2);
                out.write(29);
                out.write(119);
                out.write(2);
                out.write(29);
                out.write(104);
                out.write(60);
                out.write(29);
                out.write(107);
                out.write(4);
                k = 0;
                while (k < string.length()) {
                    c = string.charAt(k);
                    out.write(c);
                    ++k;
                }
                out.write(0);
            } else {
                if (mode == 0) {
                    out.write(27);
                    out.write(33);
                    out.write(0);
                } else if (mode == 1) {
                    out.write(27);
                    out.write(33);
                    out.write(8);
                } else if (mode == 2) {
                    out.write(29);
                    out.write(33);
                    out.write(17);
                }
                k = 0;
                while (k < string.length()) {
                    c = string.charAt(k);
                    if (c == 233) {
                        c = 130;
                    } else if (c == 232) {
                        c = 138;
                    } else if (c == 234) {
                        c = 136;
                    } else if (c == 249) {
                        c = 151;
                    } else if (c == 224) {
                        c = 133;
                    } else if (c == 231) {
                        c = 135;
                    } else if (c == 244) {
                        c = 147;
                    }
                    out.write(c);
                    ++k;
                }
            }
            out.write(10);
            ++i;
        }
        out.write(10);
        out.write(10);
        out.write(10);
        out.write(10);
        out.write(29);
        out.write(86);
        out.write(1);
        out.close();
        serialPort.close();
    }

    private SerialPort getSerialPort() throws Exception {
        if (this.port == null || this.port.length() == 0) {
            throw new IllegalStateException("Invalid serial port name: " + this.port);
        }
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.port);
        if (portIdentifier.isCurrentlyOwned()) {
            throw new IllegalAccessError("Port " + this.port + " is currently in use");
        }
        CommPort commPort = portIdentifier.open("CommUtil", 2000);
        if (!(commPort instanceof SerialPort)) {
            throw new IllegalStateException("Invalid serial port: " + this.port);
        }
        SerialPort serialPort = (SerialPort)commPort;
        serialPort.setSerialPortParams(9600, 8, 1, 0);
        return serialPort;
    }
}

