/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.openconcerto.erp.generationDoc.AbstractSheetXml;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.Tuple2;

public class VenteFactureXmlSheet
extends AbstractSheetXml {
    private String startName;
    private static final Tuple2<String, String> tuple = Tuple2.create("LocationFacture", "Factures");

    public VenteFactureXmlSheet(SQLRow row) {
        super(row);
        this.printer = PrinterNXProps.getInstance().getStringProperty("FacturePrinter");
        this.elt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)row.getObject("DATE"));
        this.locationOO = String.valueOf(SheetXml.getLocationForTuple(tuple, (boolean)false)) + File.separator + cal.get(1);
        this.locationPDF = String.valueOf(SheetXml.getLocationForTuple(tuple, (boolean)true)) + File.separator + cal.get(1);
        if (row.getBoolean("COMPLEMENT").booleanValue()) {
            this.startName = "FactureComplement_";
            this.modele = "VenteFactureComplement";
        } else if (row.getBoolean("ACOMPTE").booleanValue()) {
            this.startName = "FactureAcompte_";
            this.modele = "VenteFactureAcompte";
        } else {
            this.startName = "Facture_";
            this.modele = "VenteFacture";
        }
    }
}

