/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.model;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.element.objet.Association;
import org.openconcerto.erp.element.objet.Axe;
import org.openconcerto.erp.element.objet.ClasseCompte;
import org.openconcerto.erp.element.objet.Compte;
import org.openconcerto.erp.element.objet.RepartitionAssociation;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class AssociationAnalytiqueModel
extends AbstractTableModel {
    private Vector associations = new Vector();
    private Association[][] dataAssociations;
    private Vector repartitionsAxe = new Vector();
    private Vector axes = new Vector();
    private Vector titres = new Vector();
    private Vector comptes = new Vector();
    private Map mapCompte = new HashMap();
    private Map mapRepartition = new HashMap();
    private SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();

    public AssociationAnalytiqueModel(ClasseCompte cc) {
        SQLTable compteTable = this.base.getTable("COMPTE_PCE");
        SQLSelect selCompte = new SQLSelect(this.base);
        selCompte.addSelect(compteTable.getField("ID"));
        selCompte.addSelect(compteTable.getField("NUMERO"));
        selCompte.addSelect(compteTable.getField("NOM"));
        selCompte.setWhere(new Where((FieldRef)compteTable.getField("NUMERO"), "REGEXP", (Object)cc.getTypeNumeroCompte()));
        selCompte.addRawOrder("COMPTE_PCE.NUMERO");
        String reqCompte = selCompte.asString();
        Object obCompte = this.base.getDataSource().execute(reqCompte, new ArrayListHandler());
        List myListCompte = (List)obCompte;
        if (myListCompte.size() != 0) {
            int i = 0;
            while (i < myListCompte.size()) {
                Object[] objTmp = (Object[])myListCompte.get(i);
                this.mapCompte.put(new Integer(Integer.parseInt(objTmp[0].toString())), new Integer(this.comptes.size()));
                this.comptes.add(new Compte(Integer.parseInt(objTmp[0].toString()), objTmp[1].toString(), objTmp[2].toString()));
                ++i;
            }
        }
        SQLTable axeTable = this.base.getTable("AXE_ANALYTIQUE");
        SQLSelect selAxe = new SQLSelect(this.base);
        selAxe.addSelect(axeTable.getField("ID"));
        selAxe.addSelect(axeTable.getField("NOM"));
        selAxe.addRawOrder("AXE_ANALYTIQUE.NOM");
        String reqAxe = selAxe.asString();
        Object obAxe = this.base.getDataSource().execute(reqAxe, new ArrayListHandler());
        List myListAxe = (List)obAxe;
        this.titres.add("Compte");
        this.titres.add("Libell\u00e9");
        if (myListAxe.size() != 0) {
            int i = 0;
            while (i < myListAxe.size()) {
                Object[] objTmp = (Object[])myListAxe.get(i);
                this.axes.add(new Axe(Integer.parseInt(objTmp[0].toString()), objTmp[1].toString()));
                this.titres.add(objTmp[1].toString());
                ++i;
            }
            this.dataAssociations = new Association[this.comptes.size()][this.axes.size()];
            int j = 0;
            while (j < this.axes.size()) {
                Vector<RepartitionAssociation> repartition;
                SQLTable repTable = this.base.getTable("REPARTITION_ANALYTIQUE");
                SQLTable repElemTable = this.base.getTable("REPARTITION_ANALYTIQUE_ELEMENT");
                SQLTable posteTable = this.base.getTable("POSTE_ANALYTIQUE");
                SQLSelect selRep = new SQLSelect(this.base);
                selRep.addSelect(repTable.getField("ID"));
                selRep.addSelect(repTable.getField("NOM"));
                selRep.addSelect(posteTable.getField("NOM"));
                selRep.addSelect(repElemTable.getField("TAUX"));
                Where w = new Where((FieldRef)repElemTable.getField("ID_POSTE_ANALYTIQUE"), "=", posteTable.getField("ID"));
                Where w2 = new Where((FieldRef)repElemTable.getField("ID_REPARTITION_ANALYTIQUE"), "=", repTable.getField("ID"));
                Where w3 = new Where((FieldRef)posteTable.getField("ID_AXE_ANALYTIQUE"), "=", ((Axe)this.axes.get(j)).getId());
                selRep.setWhere(w.and(w2).and(w3));
                selRep.addRawOrder("REPARTITION_ANALYTIQUE.ID");
                String reqRep = selRep.asString();
                Object obRep = this.base.getDataSource().execute(reqRep, new ArrayListHandler());
                List myListRep = (List)obRep;
                if (myListRep.size() != 0) {
                    repartition = new Vector<RepartitionAssociation>();
                    repartition.add(new RepartitionAssociation(1, "Ind\u00e9fini", ((Axe)this.axes.get(j)).getId(), ""));
                    this.mapRepartition.put(new Integer(1), new Integer(0));
                    int valId = 0;
                    RepartitionAssociation repTmp = null;
                    int i2 = 0;
                    while (i2 < myListRep.size()) {
                        Object[] objTmp = (Object[])myListRep.get(i2);
                        if (valId != Integer.parseInt(objTmp[0].toString())) {
                            if (repTmp != null) {
                                repartition.add(repTmp);
                                this.mapRepartition.put(new Integer(Integer.parseInt(objTmp[0].toString())), new Integer(repartition.size() - 1));
                            }
                            valId = Integer.parseInt(objTmp[0].toString());
                            repTmp = (double)Float.parseFloat(objTmp[3].toString()) > 0.0 ? new RepartitionAssociation(Integer.parseInt(objTmp[0].toString()), objTmp[1].toString(), ((Axe)this.axes.get(j)).getId(), String.valueOf(objTmp[2].toString()) + ":" + objTmp[3].toString() + "%") : new RepartitionAssociation(Integer.parseInt(objTmp[0].toString()), objTmp[1].toString(), ((Axe)this.axes.get(j)).getId(), "");
                        } else if (repTmp != null && (double)Float.parseFloat(objTmp[3].toString()) > 0.0) {
                            repTmp.addValPoste(String.valueOf(objTmp[2].toString()) + ":" + objTmp[3].toString() + "%");
                        }
                        ++i2;
                    }
                    repartition.add(repTmp);
                    this.mapRepartition.put(new Integer(repTmp.getId()), new Integer(repartition.size() - 1));
                    this.repartitionsAxe.add(repartition);
                } else {
                    repartition = new Vector();
                    repartition.add(new RepartitionAssociation(1, "Ind\u00e9fini", ((Axe)this.axes.get(j)).getId(), ""));
                    this.mapRepartition.put(new Integer(1), new Integer(0));
                    this.repartitionsAxe.add(repartition);
                }
                SQLSelect selAssoc = new SQLSelect(this.base);
                SQLTable associationTable = this.base.getTable("ASSOCIATION_COMPTE_ANALYTIQUE");
                selAssoc.addSelect(associationTable.getField("ID"));
                selAssoc.addSelect(associationTable.getField("ID_COMPTE_PCE"));
                selAssoc.addSelect(associationTable.getField("ID_REPARTITION_ANALYTIQUE"));
                selAssoc.setWhere("ASSOCIATION_COMPTE_ANALYTIQUE.ID_AXE_ANALYTIQUE", "=", ((Axe)this.axes.get(j)).getId());
                String reqAssoc = selAssoc.asString();
                Object obAssoc = this.base.getDataSource().execute(reqAssoc, new ArrayListHandler());
                List myListAssoc = (List)obAssoc;
                if (myListAssoc.size() != 0) {
                    Vector<Association> assoc = new Vector<Association>();
                    int i3 = 0;
                    while (i3 < myListAssoc.size()) {
                        Object[] objTmp = (Object[])myListAssoc.get(i3);
                        Association assocTmp = new Association(Integer.parseInt(objTmp[0].toString()), Integer.parseInt(objTmp[1].toString()), Integer.parseInt(objTmp[2].toString()));
                        if (this.mapCompte.get(new Integer(assocTmp.getIdCompte())) != null && this.mapRepartition.get(new Integer(assocTmp.getIdRep())) != null) {
                            this.dataAssociations[Integer.parseInt((String)this.mapCompte.get((Object)new Integer((int)assocTmp.getIdCompte())).toString())][j] = assocTmp;
                            assoc.add(assocTmp);
                        }
                        ++i3;
                    }
                    this.associations.add(assoc);
                } else {
                    this.associations.add(new Vector());
                }
                ++j;
            }
        }
    }

    public Class getColumnClass(int c) {
        if (c > 1) {
            return RepartitionAssociation.class;
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.comptes.size();
    }

    @Override
    public int getColumnCount() {
        return this.titres.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.titres.get(col).toString();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        String numeroCompte = this.getValueAt(row, 0).toString();
        String numeroCompteSuiv = null;
        if (row < this.getRowCount() - 1) {
            numeroCompteSuiv = this.getValueAt(row + 1, 0).toString();
        }
        if (this.getValueAt(row, 0).toString().trim().length() == 1) {
            return false;
        }
        return col > 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return ((Compte)this.comptes.get(rowIndex)).getNumero();
        }
        if (columnIndex == 1) {
            return ((Compte)this.comptes.get(rowIndex)).getNom();
        }
        if (this.dataAssociations[rowIndex][columnIndex - 2] != null) {
            Association assocTmp = this.dataAssociations[rowIndex][columnIndex - 2];
            return ((Vector)this.repartitionsAxe.get(columnIndex - 2)).get(Integer.parseInt(this.mapRepartition.get(new Integer(assocTmp.getIdRep())).toString()));
        }
        if (this.isCellEditable(rowIndex, columnIndex)) {
            return ((Vector)this.repartitionsAxe.get(columnIndex - 2)).get(0);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex > 1) {
            if (this.dataAssociations[rowIndex][columnIndex - 2] != null) {
                if (((RepartitionAssociation)aValue).getId() == 1) {
                    Association assocTmp = this.dataAssociations[rowIndex][columnIndex - 2];
                    assocTmp.setSuppression(true);
                    this.validAssociation(assocTmp, columnIndex - 2);
                    this.dataAssociations[rowIndex][columnIndex - 2] = null;
                } else {
                    this.dataAssociations[rowIndex][columnIndex - 2].setIdRep(((RepartitionAssociation)aValue).getId());
                    Vector assoc = (Vector)this.associations.get(columnIndex - 2);
                    int i = 0;
                    while (i < assoc.size()) {
                        this.validAssociation((Association)assoc.get(i), columnIndex - 2);
                        ++i;
                    }
                }
            } else {
                Association assocTmp;
                if (((RepartitionAssociation)aValue).getId() == 1) {
                    return;
                }
                this.dataAssociations[rowIndex][columnIndex - 2] = assocTmp = new Association(1, ((Compte)this.comptes.get(rowIndex)).getId(), ((RepartitionAssociation)aValue).getId(), true);
                ((Vector)this.associations.get(columnIndex - 2)).add(assocTmp);
                this.validAssociation(assocTmp, columnIndex - 2);
            }
        }
    }

    public Vector getRepartitionsAxe() {
        return this.repartitionsAxe;
    }

    private void validAssociation(Association a, int index_axe) {
        block11: {
            SQLTable associationTable = this.base.getTable("ASSOCIATION_COMPTE_ANALYTIQUE");
            if (a.getSuppression()) {
                SQLRowValues vals = new SQLRowValues(associationTable);
                vals.put("ARCHIVE", 1);
                try {
                    vals.update(a.getId());
                }
                catch (SQLException e) {
                    System.err.println("Erreur suppression association " + a);
                    e.printStackTrace();
                }
                return;
            }
            if (a.getCreation()) {
                HashMap<String, Integer> m = new HashMap<String, Integer>();
                m.put("ID_REPARTITION_ANALYTIQUE", new Integer(a.getIdRep()));
                m.put("ID_COMPTE_PCE", new Integer(a.getIdCompte()));
                m.put("ID_AXE_ANALYTIQUE", new Integer(((Axe)this.axes.get(index_axe)).getId()));
                SQLRowValues val = new SQLRowValues(associationTable, m);
                try {
                    if (val.getInvalid() == null) {
                        SQLRow row = val.insert();
                        a.setId(row.getID());
                        break block11;
                    }
                    System.out.println("Impossible d'ajouter " + a + " clef etrangere invalide");
                }
                catch (SQLException e) {
                    System.out.println("Error insert row in " + val.getTable().getName());
                }
            } else if (a.getModification()) {
                SQLRowValues vals = new SQLRowValues(associationTable);
                vals.put("ID_REPARTITION_ANALYTIQUE", a.getIdRep());
                try {
                    vals.update(a.getId());
                }
                catch (SQLException e) {
                    System.out.println("Erreur modification association " + a);
                }
            }
        }
        a.setCreation(false);
        a.setModification(false);
    }
}

