/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.ui.ValiderSuppressionRepartitionFrame;
import org.openconcerto.erp.element.objet.Poste;
import org.openconcerto.erp.element.objet.Repartition;
import org.openconcerto.erp.element.objet.RepartitionElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class AnalytiqueModel
extends AbstractTableModel {
    private Vector mesTitres = new Vector();
    private Vector ligneRepartitions = new Vector();
    private List<Poste> postes = new ArrayList<Poste>();
    private List<RepartitionElement> repartitionElements = new ArrayList<RepartitionElement>();
    private List<Repartition> repartitions = new ArrayList<Repartition>();
    private int idAxe;
    private int idNewRep;
    private int idNewRepElem;
    private int idNewPoste;
    private SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();

    public AnalytiqueModel(int IDAxe) {
        this.idAxe = IDAxe;
        SQLTable posteTable = this.base.getTable("POSTE_ANALYTIQUE");
        SQLSelect sel = new SQLSelect(this.base);
        sel.addSelect(posteTable.getField("ID"));
        sel.addSelect(posteTable.getField("NOM"));
        sel.setWhere("POSTE_ANALYTIQUE.ID_AXE_ANALYTIQUE", "=", IDAxe);
        String req = sel.asString();
        Object ob = this.base.getDataSource().execute(req, new ArrayListHandler());
        List myList = (List)ob;
        this.idNewPoste = 1;
        if (myList.size() != 0) {
            int i = 0;
            while (i < myList.size()) {
                Object[] objTmp = (Object[])myList.get(i);
                this.postes.add(new Poste(Integer.parseInt(objTmp[0].toString()), objTmp[1].toString(), this.idAxe));
                if (Integer.parseInt(objTmp[0].toString()) > this.idNewPoste) {
                    this.idNewPoste = Integer.parseInt(objTmp[0].toString());
                }
                ++i;
            }
            this.mesTitres.add("R\u00e9partition");
            i = 1;
            while (i < this.postes.size() + 1) {
                this.mesTitres.add(String.valueOf(i - 1));
                ++i;
            }
            SQLSelect sel2 = new SQLSelect(this.base);
            sel2.addSelect("REPARTITION_ANALYTIQUE.NOM");
            sel2.addSelect("REPARTITION_ANALYTIQUE_ELEMENT.TAUX");
            sel2.addSelect("REPARTITION_ANALYTIQUE_ELEMENT.ID_POSTE_ANALYTIQUE");
            sel2.addSelect("REPARTITION_ANALYTIQUE_ELEMENT.ID_REPARTITION_ANALYTIQUE");
            sel2.addSelect("REPARTITION_ANALYTIQUE_ELEMENT.ID");
            Where w = new Where((FieldRef)this.base.getTable("REPARTITION_ANALYTIQUE_ELEMENT").getField("ID_REPARTITION_ANALYTIQUE"), "=", this.base.getTable("REPARTITION_ANALYTIQUE").getField("ID"));
            Where w2 = new Where((FieldRef)posteTable.getField("ID_AXE_ANALYTIQUE"), "=", this.idAxe);
            Where w3 = new Where((FieldRef)posteTable.getField("ID"), "=", this.base.getTable("REPARTITION_ANALYTIQUE_ELEMENT").getField("ID_POSTE_ANALYTIQUE"));
            sel2.setWhere(w.and(w2).and(w3));
            sel2.addRawOrder("REPARTITION_ANALYTIQUE_ELEMENT.ID_REPARTITION_ANALYTIQUE");
            String req2 = sel2.asString();
            Object ob2 = this.base.getDataSource().execute(req2, new ArrayListHandler());
            myList = (List)ob2;
            if (myList.size() != 0) {
                this.getListRepartition(myList);
            }
        } else {
            this.idNewPoste = 2;
            this.postes.add(new Poste(1, "Nouveau poste", this.idAxe, true));
            this.mesTitres.add("R\u00e9partition");
            this.mesTitres.add(String.valueOf(0));
        }
    }

    private void getListRepartition(List list) {
        int id_rep = 1;
        this.idNewRep = 1;
        this.idNewRepElem = 1;
        int i = 0;
        while (i < list.size()) {
            Object[] obj = (Object[])list.get(i);
            if (id_rep != Integer.parseInt(obj[3].toString())) {
                id_rep = Integer.parseInt(obj[3].toString());
                this.repartitions.add(new Repartition(Integer.parseInt(obj[3].toString()), obj[0].toString(), this.idAxe));
                this.ligneRepartitions.add(String.valueOf(this.repartitions.size() - 1));
                if (id_rep > this.idNewRep) {
                    this.idNewRep = id_rep;
                }
            }
            this.repartitionElements.add(new RepartitionElement(Integer.parseInt(obj[4].toString()), Integer.parseInt(obj[3].toString()), Integer.parseInt(obj[2].toString()), Float.parseFloat(obj[1].toString())));
            if (Integer.parseInt(obj[3].toString()) > this.idNewRepElem) {
                this.idNewRepElem = Integer.parseInt(obj[3].toString());
            }
            ++i;
        }
    }

    @Override
    public int getColumnCount() {
        return this.mesTitres.size();
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        int idRep = this.repartitions.get(Integer.parseInt(this.ligneRepartitions.get(parm1).toString())).getId();
        if (parm2 > 0) {
            int id_poste = this.postes.get(Integer.parseInt(this.mesTitres.get(parm2).toString())).getId();
            int i = 0;
            while (i < this.repartitionElements.size()) {
                RepartitionElement tmp = this.repartitionElements.get(i);
                if (tmp.getIdPoste() == id_poste && tmp.getIdRep() == idRep) {
                    return new Float(tmp.getTaux());
                }
                ++i;
            }
            return Float.valueOf("-1.00");
        }
        return this.repartitions.get(Integer.parseInt(this.ligneRepartitions.get(parm1).toString())).getNom();
    }

    @Override
    public int getRowCount() {
        return this.ligneRepartitions.size();
    }

    @Override
    public String getColumnName(int col) {
        if (col > 0) {
            int tmp = Integer.parseInt(this.mesTitres.get(col).toString());
            return this.postes.get(tmp).getNom();
        }
        return this.mesTitres.get(col).toString();
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return String.class;
        }
        return Float.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int idRep = this.repartitions.get(Integer.parseInt(this.ligneRepartitions.get(rowIndex).toString())).getId();
        if (aValue == null) {
            return;
        }
        if (columnIndex > 0) {
            if ((double)Float.parseFloat(aValue.toString()) < 0.0) {
                aValue = Float.valueOf("0.0");
            }
            if ((double)Float.parseFloat(aValue.toString()) > 100.0) {
                aValue = Float.valueOf("100.0");
            }
            int id_poste = this.postes.get(Integer.parseInt(this.mesTitres.get(columnIndex).toString())).getId();
            int i = 0;
            while (i < this.repartitionElements.size()) {
                RepartitionElement tmp = this.repartitionElements.get(i);
                if (tmp.getIdPoste() == id_poste && tmp.getIdRep() == idRep) {
                    tmp.setTaux(Float.parseFloat(aValue.toString()));
                }
                ++i;
            }
        } else {
            this.repartitions.get(Integer.parseInt(this.ligneRepartitions.get(rowIndex).toString())).setNom(aValue.toString());
        }
    }

    public void addElement() {
        int idRepTmp = this.repartitions.size();
        int idElemTmp = this.repartitionElements.size();
        ++this.idNewRep;
        this.repartitions.add(new Repartition(this.idNewRep, "Nouvelle r\u00e9partition", this.idAxe, true));
        this.ligneRepartitions.add(String.valueOf(idRepTmp));
        int nbElemAdd = 0;
        int i = 1;
        while (i < this.mesTitres.size()) {
            ++this.idNewRepElem;
            ++nbElemAdd;
            this.repartitionElements.add(new RepartitionElement(this.idNewRepElem, this.idNewRep, this.postes.get(Integer.parseInt(this.mesTitres.get(i).toString())).getId(), 0.0f, true));
            ++i;
        }
        this.fireTableDataChanged();
    }

    public void removeElement(int[] listeRows) {
        if (this.ligneRepartitions.size() > 0 && listeRows != null) {
            int i = 0;
            while (i < listeRows.length) {
                this.removeElement(listeRows[i] - i);
                ++i;
            }
        }
    }

    public void removeElement(int row) {
        Repartition rep = this.repartitions.get(Integer.parseInt(this.ligneRepartitions.get(row).toString()));
        SQLTable assocTable = this.base.getTable("ASSOCIATION_COMPTE_ANALYTOQUE");
        SQLSelect selAssoc = new SQLSelect(this.base);
        selAssoc.addSelect(assocTable.getField("ID"));
        selAssoc.addSelect(assocTable.getField("ID_COMPTE_PCE"));
        selAssoc.setWhere("ASSOCIATION_COMPTE_ANALYTIQUE.ID_REPARTITION_ANALYTIQUE", "=", rep.getId());
        String reqAssoc = selAssoc.asString();
        Object obAssoc = this.base.getDataSource().execute(reqAssoc, new ArrayListHandler());
        List myListAssoc = (List)obAssoc;
        if (myListAssoc.size() != 0) {
            System.out.println("La r\u00e9partition est affect\u00e9e \u00e0 un compte.");
            ValiderSuppressionRepartitionFrame validFrame = new ValiderSuppressionRepartitionFrame(this, row, myListAssoc);
            validFrame.pack();
            validFrame.setVisible(true);
        } else {
            this.deleteElement(row);
        }
    }

    public void deleteElement(int row) {
        Repartition rep = this.repartitions.get(Integer.parseInt(this.ligneRepartitions.get(row).toString()));
        rep.setSuppression(true);
        int nbElementSuppr = 0;
        int j = 0;
        while (j < this.repartitionElements.size()) {
            RepartitionElement repElem = this.repartitionElements.get(j);
            if (repElem.getIdRep() == rep.getId()) {
                repElem.setSuppression(true);
                ++nbElementSuppr;
            }
            ++j;
        }
        j = row;
        while (j < this.ligneRepartitions.size() - 1) {
            this.ligneRepartitions.set(j, new String(this.ligneRepartitions.get(j + 1).toString()));
            ++j;
        }
        this.ligneRepartitions.remove(this.ligneRepartitions.size() - 1);
        this.fireTableDataChanged();
    }

    public void addPoste(String nom) {
        ++this.idNewPoste;
        if (nom.trim().length() != 0) {
            this.postes.add(new Poste(this.idNewPoste, nom, this.idAxe, true));
        } else {
            this.postes.add(new Poste(this.idNewPoste, "Nouveau poste", this.idAxe, true));
        }
        this.mesTitres.add(String.valueOf(this.postes.size() - 1));
        int nbElemAdd = 0;
        int i = 0;
        while (i < this.ligneRepartitions.size()) {
            ++this.idNewRepElem;
            ++nbElemAdd;
            this.repartitionElements.add(new RepartitionElement(this.idNewRepElem, this.repartitions.get(Integer.parseInt(this.ligneRepartitions.get(i).toString())).getId(), this.idNewPoste, 0.0f, true));
            ++i;
        }
        this.fireTableStructureChanged();
    }

    public void removePoste(int column) {
        if (this.mesTitres.size() > 2 && column > 0) {
            Poste p = this.postes.get(Integer.parseInt(this.mesTitres.get(column).toString()));
            p.setSuppression(true);
            int nbElemSuppr = 0;
            int i = 0;
            while (i < this.repartitionElements.size()) {
                RepartitionElement repE = this.repartitionElements.get(i);
                if (repE.getIdPoste() == p.getId()) {
                    repE.setSuppression(true);
                    ++nbElemSuppr;
                }
                ++i;
            }
            i = column;
            while (i < this.mesTitres.size() - 1) {
                this.mesTitres.set(i, new String(this.mesTitres.get(i + 1).toString()));
                ++i;
            }
            this.mesTitres.remove(this.mesTitres.size() - 1);
            this.fireTableStructureChanged();
        }
    }

    public void modifierNomPoste(int column, String nom) {
        Poste p = this.postes.get(Integer.parseInt(this.mesTitres.get(column).toString()));
        p.setNom(nom);
        this.fireTableStructureChanged();
    }

    public List<Repartition> getRepartition() {
        return this.repartitions;
    }

    public List<RepartitionElement> getRepartitionElem() {
        return this.repartitionElements;
    }

    public List<Poste> getPostes() {
        return this.postes;
    }
}

