/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import org.openconcerto.erp.core.common.ui.ITextComboVilleTableCellEditor;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class AdresseClientItemTable
extends JPanel {
    private RowValuesTable table;
    private SQLTableElement cedex;
    private SQLTableElement hasCedex;
    private SQLTableElement ville;
    private SQLTableElement rue;
    private RowValuesTableModel model;
    private SQLRowValues defaultRowVals;

    public AdresseClientItemTable() {
        this.init();
        this.uiInit();
        this.defaultRowVals = new SQLRowValues(this.getSQLElement().getTable());
        this.defaultRowVals.put("PAYS", "France");
    }

    protected void init() {
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        this.rue = new SQLTableElement(e.getTable().getField("RUE"));
        list.add(this.rue);
        this.ville = new SQLTableElement(e.getTable().getField("VILLE"), String.class, new ITextComboVilleTableCellEditor());
        list.add(this.ville);
        this.hasCedex = new SQLTableElement(e.getTable().getField("HAS_CEDEX"));
        list.add(this.hasCedex);
        this.cedex = new SQLTableElement(e.getTable().getField("CEDEX"));
        list.add(this.cedex);
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("VILLE"));
        this.table = new RowValuesTable(this.model, null, true);
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
    }

    protected void uiInit() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        RowValuesTableControlPanel control = new RowValuesTableControlPanel(this.table);
        this.add((Component)control, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), c);
        this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
    }

    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("ADRESSE");
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }
}

