/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererUtils;
import org.openconcerto.utils.GestionDevise;

public class DeviseNiceTableCellRenderer
extends DefaultTableCellRenderer {
    public static final Color couleurFacture = new Color(225, 254, 207);
    public static final Color couleurFactureMore = new Color(215, 244, 197);
    public static final Color couleurFactureDark = couleurFacture.darker();
    public static final Color couleurBon = new Color(253, 243, 204);
    public static final Color couleurBonMore = new Color(243, 233, 194);
    public static final Color couleurBonDark = couleurBon.darker();
    private static final SimpleDateFormat format = new SimpleDateFormat("dd MMM yyyy");

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableCellRendererUtils.setColors(this, table, isSelected);
        this.setHorizontalAlignment(2);
        if (table.getColumnClass(column) == Long.class || table.getColumnClass(column) == BigInteger.class) {
            if (value != null && (value.getClass() == Long.class || value.getClass() == BigInteger.class)) {
                this.setText(GestionDevise.currencyToString(Long.valueOf(value.toString())));
                this.setHorizontalAlignment(4);
            }
        } else if (!(table.getColumnClass(column) != Date.class && table.getColumnClass(column) != java.sql.Date.class || value == null || value.getClass() != Date.class && value.getClass() != java.sql.Date.class)) {
            Date date = (Date)value;
            this.setText(format.format(date));
        }
        return this;
    }
}

