/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.AbstractGraphIterator;

public abstract class CrossComponentIterator<V, E, D>
extends AbstractGraphIterator<V, E> {
    private final ConnectedComponentTraversalEvent ccFinishedEvent = new ConnectedComponentTraversalEvent(this, 32);
    private final ConnectedComponentTraversalEvent ccStartedEvent = new ConnectedComponentTraversalEvent(this, 31);
    private FlyweightEdgeEvent<V, E> reusableEdgeEvent;
    private FlyweightVertexEvent<V> reusableVertexEvent;
    private Iterator<V> vertexIterator = null;
    private Map<V, D> seen = new HashMap<V, D>();
    private V startVertex;
    private Specifics<V, E> specifics;
    private final Graph<V, E> graph;
    private int state = 1;

    public CrossComponentIterator(Graph<V, E> g, V startVertex) {
        if (g == null) {
            throw new IllegalArgumentException("graph must not be null");
        }
        this.graph = g;
        this.specifics = CrossComponentIterator.createGraphSpecifics(g);
        this.vertexIterator = g.vertexSet().iterator();
        this.setCrossComponentTraversal(startVertex == null);
        this.reusableEdgeEvent = new FlyweightEdgeEvent((Object)this, null);
        this.reusableVertexEvent = new FlyweightVertexEvent<Object>((Object)this, null);
        if (startVertex == null) {
            this.startVertex = this.vertexIterator.hasNext() ? this.vertexIterator.next() : null;
        } else if (g.containsVertex(startVertex)) {
            this.startVertex = startVertex;
        } else {
            throw new IllegalArgumentException("graph must contain the start vertex");
        }
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public boolean hasNext() {
        if (this.startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.isConnectedComponentExhausted()) {
            if (this.state == 2) {
                this.state = 3;
                this.fireConnectedComponentFinished(this.ccFinishedEvent);
            }
            if (this.isCrossComponentTraversal()) {
                while (this.vertexIterator.hasNext()) {
                    V v = this.vertexIterator.next();
                    if (this.isSeenVertex(v)) continue;
                    this.encounterVertex(v, null);
                    this.state = 1;
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public V next() {
        if (this.startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            if (this.state == 1) {
                this.state = 2;
                this.fireConnectedComponentStarted(this.ccStartedEvent);
            }
            V nextVertex = this.provideNextVertex();
            this.fireVertexTraversed(this.createVertexTraversalEvent(nextVertex));
            this.addUnseenChildrenOf(nextVertex);
            return nextVertex;
        }
        throw new NoSuchElementException();
    }

    protected abstract boolean isConnectedComponentExhausted();

    protected abstract void encounterVertex(V var1, E var2);

    protected abstract V provideNextVertex();

    protected D getSeenData(V vertex) {
        return this.seen.get(vertex);
    }

    protected boolean isSeenVertex(Object vertex) {
        return this.seen.containsKey(vertex);
    }

    protected abstract void encounterVertexAgain(V var1, E var2);

    protected D putSeenData(V vertex, D data) {
        return this.seen.put(vertex, data);
    }

    static <V, E> Specifics<V, E> createGraphSpecifics(Graph<V, E> g) {
        if (g instanceof DirectedGraph) {
            return new DirectedSpecifics((DirectedGraph)g);
        }
        return new UndirectedSpecifics<V, E>(g);
    }

    private void addUnseenChildrenOf(V vertex) {
        for (E edge : this.specifics.edgesOf(vertex)) {
            this.fireEdgeTraversed(this.createEdgeTraversalEvent(edge));
            V oppositeV = Graphs.getOppositeVertex(this.graph, edge, vertex);
            if (this.isSeenVertex(oppositeV)) {
                this.encounterVertexAgain(oppositeV, edge);
                continue;
            }
            this.encounterVertex(oppositeV, edge);
        }
    }

    private EdgeTraversalEvent<V, E> createEdgeTraversalEvent(E edge) {
        if (this.isReuseEvents()) {
            this.reusableEdgeEvent.setEdge(edge);
            return this.reusableEdgeEvent;
        }
        return new EdgeTraversalEvent(this, edge);
    }

    private VertexTraversalEvent<V> createVertexTraversalEvent(V vertex) {
        if (this.isReuseEvents()) {
            this.reusableVertexEvent.setVertex(vertex);
            return this.reusableVertexEvent;
        }
        return new VertexTraversalEvent<V>(this, vertex);
    }

    private void encounterStartVertex() {
        this.encounterVertex(this.startVertex, null);
        this.startVertex = null;
    }

    private static class DirectedSpecifics<VV, EE>
    extends Specifics<VV, EE> {
        private DirectedGraph<VV, EE> graph;

        public DirectedSpecifics(DirectedGraph<VV, EE> g) {
            this.graph = g;
        }

        @Override
        public Set<? extends EE> edgesOf(VV vertex) {
            return this.graph.outgoingEdgesOf(vertex);
        }
    }

    static class FlyweightEdgeEvent<VV, localE>
    extends EdgeTraversalEvent<VV, localE> {
        public FlyweightEdgeEvent(Object eventSource, localE edge) {
            super(eventSource, edge);
        }

        protected void setEdge(localE edge) {
            this.edge = edge;
        }
    }

    static class FlyweightVertexEvent<VV>
    extends VertexTraversalEvent<VV> {
        public FlyweightVertexEvent(Object eventSource, VV vertex) {
            super(eventSource, vertex);
        }

        protected void setVertex(VV vertex) {
            this.vertex = vertex;
        }
    }

    static abstract class Specifics<VV, EE> {
        Specifics() {
        }

        public abstract Set<? extends EE> edgesOf(VV var1);
    }

    private static class UndirectedSpecifics<VV, EE>
    extends Specifics<VV, EE> {
        private Graph<VV, EE> graph;

        public UndirectedSpecifics(Graph<VV, EE> g) {
            this.graph = g;
        }

        @Override
        public Set<EE> edgesOf(VV vertex) {
            return this.graph.edgesOf(vertex);
        }
    }
}

