/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;

public class TransactionCommand
extends Prepared {
    private int type;
    private String savepointName;
    private String transactionName;

    public TransactionCommand(Session session, int n) {
        super(session);
        this.type = n;
    }

    public void setSavepointName(String string) {
        this.savepointName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() {
        switch (this.type) {
            case 1: {
                this.session.setAutoCommit(true);
                break;
            }
            case 2: {
                this.session.setAutoCommit(false);
                break;
            }
            case 15: {
                this.session.begin();
                break;
            }
            case 3: {
                this.session.commit(false);
                break;
            }
            case 4: {
                this.session.rollback();
                break;
            }
            case 5: {
                this.session.getUser().checkAdmin();
                this.session.getDatabase().checkpoint();
                break;
            }
            case 6: {
                this.session.addSavepoint(this.savepointName);
                break;
            }
            case 7: {
                this.session.rollbackToSavepoint(this.savepointName);
                break;
            }
            case 8: {
                this.session.getUser().checkAdmin();
                this.session.getDatabase().sync();
                break;
            }
            case 9: {
                this.session.prepareCommit(this.transactionName);
                break;
            }
            case 10: {
                this.session.getUser().checkAdmin();
                this.session.setPreparedTransaction(this.transactionName, true);
                break;
            }
            case 11: {
                this.session.getUser().checkAdmin();
                this.session.setPreparedTransaction(this.transactionName, false);
                break;
            }
            case 13: {
                this.session.getUser().checkAdmin();
                this.session.getDatabase().shutdownImmediately();
                break;
            }
            case 12: 
            case 14: {
                this.session.getUser().checkAdmin();
                this.session.commit(false);
                if (this.type == 14) {
                    this.session.getDatabase().setCompactFully(true);
                }
                this.session.getDatabase().setCloseDelay(0);
                Database database = this.session.getDatabase();
                this.session.throttle();
                for (Session session : database.getSessions(false)) {
                    if (database.isMultiThreaded()) {
                        Session session2 = session;
                        synchronized (session2) {
                            session.rollback();
                        }
                    } else {
                        session.rollback();
                    }
                    if (session == this.session) continue;
                    session.close();
                }
                this.session.close();
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return 0;
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean needRecompile() {
        return false;
    }

    public void setTransactionName(String string) {
        this.transactionName = string;
    }

    public ResultInterface queryMeta() {
        return null;
    }
}

