/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml.persistence;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.jdom.Element;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.xml.persistence.XMLable;

public class XMLFactory {
    private static final BidiMap elementNames = new DualHashBidiMap();
    private static final Map<Class, Method> methods = new HashMap<Class, Method>();

    public static void addClass(String elemName, Class<?> clazz) {
        if (!XMLable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("class is not a XMLable");
        }
        try {
            Method fromXML = clazz.getDeclaredMethod("fromXML", Element.class);
            methods.put(clazz, fromXML);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("fromXML is not acessible in " + clazz);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("fromXML is does not exist in " + clazz);
        }
        elementNames.put(elemName, clazz);
    }

    public static XMLable fromXML(Element elem) {
        Class clazz = XMLFactory.getClass(elem.getName());
        if (clazz == null) {
            throw new IllegalArgumentException("class of element unknown:" + elem.getName() + ":" + elementNames);
        }
        Method fromXML = methods.get(clazz);
        XMLable obj = null;
        try {
            obj = (XMLable)fromXML.invoke(null, elem);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
        return obj;
    }

    public static MultiMap fromXML(Collection elems) {
        CollectionMap res = new CollectionMap();
        for (Element elem : elems) {
            Class clazz = XMLFactory.getClass(elem.getName());
            if (clazz == null) continue;
            res.put(clazz, XMLFactory.fromXML(elem));
        }
        return res;
    }

    public static String getElementName(Class clazz) {
        return (String)elementNames.getKey(clazz);
    }

    public static String getNonNullElementName(Class clazz) {
        String name = XMLFactory.getElementName(clazz);
        if (name == null) {
            throw new IllegalStateException(clazz + " is not registered with addClass.");
        }
        return name;
    }

    public static Element getElement(Class clazz) {
        return new Element(XMLFactory.getNonNullElementName(clazz));
    }

    static Class getClass(String element) {
        return (Class)elementNames.get(element);
    }

    public static Class getNonNullClass(String element) {
        Class clazz = XMLFactory.getClass(element);
        if (clazz == null) {
            throw new IllegalStateException(String.valueOf(element) + " is not registered with addClass.");
        }
        return clazz;
    }
}

