/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import javax.xml.validation.Schema;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.xml.JDOMUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class Validator {
    private final Document doc;

    protected Validator(Document doc) {
        this.doc = doc;
    }

    protected final Document getDoc() {
        return this.doc;
    }

    public abstract String isValid();

    public abstract CollectionMap<String, String> validateCompletely();

    public static final class DTDValidator
    extends Validator {
        private final SAXBuilder b;

        public DTDValidator(Document doc) {
            this(doc, new SAXBuilder());
        }

        public DTDValidator(Document doc, SAXBuilder b) {
            super(doc);
            this.b = b;
        }

        @Override
        public String isValid() {
            try {
                JDOMUtils.validateDTD(this.getDoc(), this.b, null);
                return null;
            }
            catch (JDOMException e) {
                return ExceptionUtils.getStackTrace(e);
            }
        }

        @Override
        public CollectionMap<String, String> validateCompletely() {
            try {
                RecordingErrorHandler recErrorHandler = new RecordingErrorHandler();
                JDOMUtils.validateDTD(this.getDoc(), this.b, recErrorHandler);
                return recErrorHandler.getMap();
            }
            catch (JDOMException e) {
                throw new IllegalStateException("Unable to read the document", e);
            }
        }
    }

    public static final class JAXPValidator
    extends Validator {
        private final Schema schema;

        public JAXPValidator(Document doc, Schema schema) {
            super(doc);
            this.schema = schema;
        }

        @Override
        public String isValid() {
            SAXException exn = JDOMUtils.validate(this.getDoc(), this.schema, null);
            if (exn == null) {
                return null;
            }
            if (exn instanceof SAXParseException) {
                return String.valueOf(exn.getLocalizedMessage()) + " " + RecordingErrorHandler.getDesc((SAXParseException)exn);
            }
            return exn.getLocalizedMessage();
        }

        @Override
        public CollectionMap<String, String> validateCompletely() {
            RecordingErrorHandler recErrorHandler = new RecordingErrorHandler();
            SAXException exn = JDOMUtils.validate(this.getDoc(), this.schema, recErrorHandler);
            assert (exn == null) : "Exception thrown despite the error handler";
            return recErrorHandler.getMap();
        }
    }

    private static final class RecordingErrorHandler
    implements ErrorHandler {
        private final CollectionMap<String, String> res;

        private RecordingErrorHandler() {
            this(new CollectionMap<String, String>());
        }

        private RecordingErrorHandler(CollectionMap<String, String> res) {
            this.res = res;
        }

        public final CollectionMap<String, String> getMap() {
            return this.res;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.addExn("WARNING", e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.addExn("FATAL", e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.addExn("ERROR", e);
        }

        private void addExn(String level, SAXParseException e) {
            this.res.put((Object)(String.valueOf(level) + " " + e.getMessage()), (Object)RecordingErrorHandler.getDesc(e));
        }

        static String getDesc(SAXParseException e) {
            String f = e.getSystemId() == null ? "" : " of document " + e.getSystemId();
            return "on line " + e.getLineNumber() + ":" + e.getColumnNumber() + f;
        }
    }
}

