/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.convertor;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.utils.ReflectUtils;
import org.openconcerto.utils.convertor.DateTSConvertor;
import org.openconcerto.utils.convertor.ReverseConvertor;
import org.openconcerto.utils.convertor.StringClobConvertor;
import org.openconcerto.utils.convertor.ValueConvertor;

public final class ValueConvertorFactory {
    private static final List<ValueConvertor<?, ?>> convs = new ArrayList();

    static {
        convs.add(new DateTSConvertor());
        convs.add(StringClobConvertor.INSTANCE);
    }

    public static final <T, U> ValueConvertor<T, U> find(Class<T> c1, Class<U> c2) {
        for (ValueConvertor<?, ?> vc : convs) {
            List<Class<?>> args = ReflectUtils.getTypeArguments(vc, ValueConvertor.class);
            if (args.size() != 2) {
                throw new IllegalStateException(vc + " don't specify type arguments");
            }
            if (args.get(0).equals(c1) && args.get(1).equals(c2)) {
                return vc;
            }
            if (!args.get(0).equals(c2) || !args.get(1).equals(c1)) continue;
            return new ReverseConvertor(vc);
        }
        return null;
    }
}

