/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.checks;

import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;

public final class ChainValidListener
implements ValidListener {
    private final ValidListener delegate;
    private final ValidObject target;

    public ChainValidListener(ValidObject target, ValidListener delegate) {
        if (target == null || delegate == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.delegate = delegate;
    }

    @Override
    public void validChange(ValidObject src, boolean newValue) {
        this.delegate.validChange(this.target, newValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.delegate.hashCode();
        result = 31 * result + this.target.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChainValidListener other = (ChainValidListener)obj;
        return this.delegate.equals(other.delegate) && this.target.equals(other.target);
    }
}

