/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.openconcerto.utils.DropperQueue;
import org.openconcerto.utils.IFutureTask;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;

public class SleepingQueue {
    private final String name;
    private final PropertyChangeSupport support;
    private FutureTask<?> beingRun;
    private final SingleThreadedExecutor tasksQueue;
    private boolean canceling;
    private IPredicate<FutureTask<?>> cancelPredicate;

    public SleepingQueue() {
        this(String.valueOf(SleepingQueue.class.getName()) + System.currentTimeMillis());
    }

    public SleepingQueue(String name) {
        this.name = name;
        this.canceling = false;
        this.cancelPredicate = null;
        this.support = new PropertyChangeSupport(this);
        this.setBeingRun(null);
        this.tasksQueue = new SingleThreadedExecutor();
        this.tasksQueue.start();
    }

    protected void customizeThread(Thread thr) {
        thr.setPriority(1);
    }

    public final FutureTask<?> put(Runnable workRunnable) {
        if (this.shallAdd(workRunnable)) {
            IFutureTask t = this.tasksQueue.newTaskFor(workRunnable);
            this.add(t);
            return t;
        }
        return null;
    }

    public final <F extends FutureTask<?>> F execute(F t) {
        if (this.shallAdd(t)) {
            this.add(t);
            return t;
        }
        return null;
    }

    private void add(FutureTask<?> t) {
        if (this.isDead()) {
            throw new IllegalStateException("cannot exec " + t);
        }
        this.tasksQueue.put(t);
    }

    private final boolean shallAdd(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("null runnable");
        }
        try {
            this.willPut(runnable);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected void willPut(Runnable r) throws InterruptedException {
    }

    protected final void cancel() {
        this.cancel(null);
    }

    protected final void cancel(final IPredicate<FutureTask<?>> pred) {
        this.tasksDo(new IClosure<Collection<FutureTask<?>>>(){

            @Override
            public void executeChecked(Collection<FutureTask<?>> tasks) {
                SleepingQueue.this.cancel(pred, tasks);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancel(IPredicate<FutureTask<?>> pred, Collection<FutureTask<?>> tasks) {
        try {
            SleepingQueue sleepingQueue = this;
            synchronized (sleepingQueue) {
                this.canceling = true;
                this.cancelPredicate = pred;
                this.cancelCheck(this.getBeingRun());
            }
            for (FutureTask<?> t : tasks) {
                this.cancelCheck(t);
            }
        }
        catch (Throwable throwable) {
            SleepingQueue sleepingQueue = this;
            synchronized (sleepingQueue) {
                this.canceling = false;
                this.cancelPredicate = null;
            }
            throw throwable;
        }
        SleepingQueue sleepingQueue = this;
        synchronized (sleepingQueue) {
            this.canceling = false;
            this.cancelPredicate = null;
        }
    }

    public final void tasksDo(IClosure<? super BlockingDeque<FutureTask<?>>> c) {
        this.tasksQueue.itemsDo(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelCheck(FutureTask<?> t) {
        if (t != null) {
            SleepingQueue sleepingQueue = this;
            synchronized (sleepingQueue) {
                if (this.canceling && (this.cancelPredicate == null || this.cancelPredicate.evaluateChecked(t))) {
                    t.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBeingRun(FutureTask<?> beingRun) {
        FutureTask<?> old;
        SleepingQueue sleepingQueue = this;
        synchronized (sleepingQueue) {
            old = this.beingRun;
            this.beingRun = beingRun;
        }
        this.support.firePropertyChange("beingRun", old, beingRun);
    }

    protected final synchronized FutureTask<?> getBeingRun() {
        return this.beingRun;
    }

    public boolean isSleeping() {
        return this.tasksQueue.isSleeping();
    }

    public void setSleeping(boolean sleeping) {
        if (this.tasksQueue.setSleeping(sleeping)) {
            this.support.firePropertyChange("sleeping", null, (Object)this.isSleeping());
        }
    }

    public final void die() {
        this.tasksQueue.die();
        this.dying();
    }

    protected void dying() {
    }

    public final boolean isDead() {
        return this.tasksQueue.isDead();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void rmPropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " Queue: " + this.tasksQueue + " run:" + this.getBeingRun();
    }

    private final class SingleThreadedExecutor
    extends DropperQueue<FutureTask<?>> {
        private SingleThreadedExecutor() {
            super(String.valueOf(SleepingQueue.this.name) + System.currentTimeMillis());
            SleepingQueue.this.customizeThread(this);
        }

        protected <T> IFutureTask<T> newTaskFor(Runnable task) {
            return this.newTaskFor(task, null);
        }

        protected <T> IFutureTask<T> newTaskFor(Runnable task, T value) {
            return new IFutureTask<T>(task, value, " for {" + SleepingQueue.this.name + "}");
        }

        @Override
        protected void process(FutureTask<?> task) {
            block3: {
                if (!task.isDone()) {
                    boolean ran = false;
                    this.beforeExecute(task);
                    try {
                        task.run();
                        ran = true;
                        this.afterExecute(task, null);
                    }
                    catch (RuntimeException ex) {
                        if (ran) break block3;
                        this.afterExecute(task, ex);
                    }
                }
            }
        }

        protected void beforeExecute(FutureTask<?> f) {
            SleepingQueue.this.cancelCheck(f);
            SleepingQueue.this.setBeingRun(f);
        }

        protected void afterExecute(FutureTask<?> f, Throwable t) {
            SleepingQueue.this.setBeingRun(null);
            try {
                f.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

