/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ProductInfo {
    private static final ProductInfo INSTANCE = new ProductInfo();
    private Properties props = null;

    public static final synchronized ProductInfo getInstance() {
        return INSTANCE;
    }

    private ProductInfo() {
    }

    public final Properties getProps() {
        if (this.props == null) {
            try {
                InputStream stream = this.getClass().getResourceAsStream("/product.properties");
                if (stream != null) {
                    Properties loadingProps = new Properties();
                    loadingProps.load(stream);
                    this.props = loadingProps;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to load product properties", e);
            }
        }
        return this.props;
    }
}

