/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;

public abstract class PrefType<T> {
    public static final PrefType<String> STRING_TYPE = new PrefType<String>(String.class, null, null){

        @Override
        public void put(Preferences prefs, String prefKey, Object val) {
            prefs.put(prefKey, String.valueOf(val));
        }

        @Override
        public String get(Preferences prefs, String prefKey, String def) {
            return prefs.get(prefKey, def);
        }
    };
    public static final PrefType<Boolean> BOOLEAN_TYPE = new PrefType<Boolean>(Boolean.class, Boolean.TYPE, Boolean.FALSE){

        @Override
        public void put(Preferences prefs, String prefKey, Object val) {
            prefs.putBoolean(prefKey, (Boolean)val);
        }

        @Override
        public Boolean get(Preferences prefs, String prefKey, Boolean def) {
            return prefs.getBoolean(prefKey, def);
        }
    };
    public static final PrefType<Float> FLOAT_TYPE = new PrefType<Float>(Float.class, Float.TYPE, Float.valueOf(0.0f)){

        @Override
        public void put(Preferences prefs, String prefKey, Object val) {
            prefs.putFloat(prefKey, ((Number)val).floatValue());
        }

        @Override
        public Float get(Preferences prefs, String prefKey, Float def) {
            return Float.valueOf(prefs.getFloat(prefKey, def.floatValue()));
        }
    };
    public static final PrefType<Double> DOUBLE_TYPE = new PrefType<Double>(Double.class, Double.TYPE, Double.valueOf(0.0)){

        @Override
        public void put(Preferences prefs, String prefKey, Object val) {
            prefs.putDouble(prefKey, ((Number)val).doubleValue());
        }

        @Override
        public Double get(Preferences prefs, String prefKey, Double def) {
            return prefs.getDouble(prefKey, def);
        }
    };
    public static final PrefType<Integer> INT_TYPE = new PrefType<Integer>(Integer.class, Integer.TYPE, Integer.valueOf(0)){

        @Override
        public void put(Preferences prefs, String prefKey, Object val) {
            prefs.putInt(prefKey, ((Number)val).intValue());
        }

        @Override
        public Integer get(Preferences prefs, String prefKey, Integer def) {
            return prefs.getInt(prefKey, def);
        }
    };
    public static final PrefType<Long> LONG_TYPE = new PrefType<Long>(Long.class, Long.TYPE, Long.valueOf(0L)){

        @Override
        public void put(Preferences prefs, String prefKey, Object val) {
            prefs.putLong(prefKey, ((Number)val).longValue());
        }

        @Override
        public Long get(Preferences prefs, String prefKey, Long def) {
            return prefs.getLong(prefKey, def);
        }
    };
    public static final PrefType<byte[]> BYTE_ARRAY_TYPE = new PrefType<byte[]>(byte[].class, null, null){

        @Override
        public void put(Preferences prefs, String prefKey, Object val) {
            prefs.putByteArray(prefKey, (byte[])val);
        }

        @Override
        public byte[] get(Preferences prefs, String prefKey, byte[] def) {
            return prefs.getByteArray(prefKey, def);
        }
    };
    public static final PrefType<?>[] VALUES = new PrefType[]{STRING_TYPE, BOOLEAN_TYPE, FLOAT_TYPE, DOUBLE_TYPE, INT_TYPE, LONG_TYPE, BYTE_ARRAY_TYPE};
    public static final Set<PrefType<?>> VALUES_COLLECTION = Collections.unmodifiableSet(new HashSet(Arrays.asList(VALUES)));
    private final Class<T> clazz;
    private final Class<T> primitiveClass;
    private final T defaultValue;

    private PrefType(Class<T> clazz, Class<T> primitiveClass, T defaultValue) {
        this.clazz = clazz;
        if (this.clazz == null) {
            throw new IllegalArgumentException();
        }
        this.primitiveClass = primitiveClass;
        this.defaultValue = defaultValue;
    }

    public final Class<T> getTypeClass() {
        return this.clazz;
    }

    public final Class<T> getPrimitiveTypeClass() {
        return this.primitiveClass;
    }

    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public abstract void put(Preferences var1, String var2, Object var3);

    public abstract T get(Preferences var1, String var2, T var3);

    public final T get(Preferences prefs, String prefKey) {
        return this.get(prefs, prefKey, this.getDefaultValue());
    }

    /* synthetic */ PrefType(Class clazz, Class clazz2, Object object, PrefType prefType) {
        this(clazz, clazz2, object);
    }
}

