/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

public class Nombre {
    private int nb;
    static final String[] ref0 = new String[]{"z\u00e9ro", "un", "deux", "trois", "quatre", "cinq", "six", "sept", "huit", "neuf", "dix", "onze", "douze", "treize", "quatorze", "quinze", "seize", "dix sept", "dix huit", "dix neuf", "vingt"};
    static final String[] ref10 = new String[]{"z\u00e9ro", "dix", "vingt", "trente", "quarante", "cinquante", "soixante", "soixante", "quatre vingt", "quatre vingt", "cent"};
    static final String[] refmult = new String[]{"mille", "million", "milliard", "billion", "trillion"};
    static int[] puissanceMille;
    static final String[] ref0Eng;
    static final String[] ref10Eng;
    static final String[] refmultEng;
    public static int FR;
    public static int EN;
    private int language = FR;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1000;
        nArray[2] = 1000000;
        nArray[3] = 1000000000;
        puissanceMille = nArray;
        ref0Eng = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty"};
        ref10Eng = new String[]{"zero", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety", "hundred"};
        refmultEng = new String[]{"thousand", "million", "billion", "billion", "trillion"};
        FR = 0;
        EN = 1;
    }

    public Nombre(int i) {
        this(i, FR);
    }

    public Nombre(int i, int language) {
        this.nb = i;
        this.language = language;
    }

    public String getText() {
        StringBuffer result = new StringBuffer();
        if (this.nb < 0) {
            result.append("moins ");
        }
        if (this.nb <= 20) {
            result.append(this.language == FR ? ref0[this.nb] : ref0Eng[this.nb]);
        } else if (this.nb < 100) {
            int decimal = this.nb / 10;
            int unit = this.nb % 10;
            result.append(this.language == FR ? ref10[decimal] : ref10Eng[decimal]);
            if (this.language == EN || decimal != 7 && decimal != 9) {
                if (unit > 0) {
                    if (unit == 1) {
                        result.append(this.language == FR ? " et" : " and");
                    }
                    result.append(" " + (this.language == FR ? ref0[unit] : ref0Eng[unit]));
                }
            } else {
                if (unit == 1) {
                    result.append(this.language == FR ? " et" : " and");
                }
                result.append(" " + (this.language == FR ? ref0[unit + 10] : ref0Eng[unit + 10]));
            }
        } else if (this.nb < 1000) {
            int cent = this.nb / 100;
            if (cent == 1) {
                result.append(this.language == FR ? "cent" : "one hundred");
            } else {
                result.append(String.valueOf(this.language == FR ? ref0[cent] : ref0Eng[cent]) + (this.language == FR ? " cent" : " hundred"));
            }
            int reste = this.nb - cent * 100;
            if (reste > 0) {
                Nombre d = new Nombre(reste, this.language);
                result.append(" " + d.getText());
            }
        } else {
            int longueur = new Double(Math.ceil((double)String.valueOf(this.nb).length() / 3.0)).intValue();
            int cumul = 0;
            int i = longueur - 1;
            while (i > 0) {
                int puissancei = puissanceMille[i];
                int val = (this.nb - cumul) / puissancei;
                if (val > 0) {
                    if (val > 1 && i - 1 > 0) {
                        result.append(String.valueOf(new Nombre(val, this.language).getText()) + " " + (this.language == FR ? refmult[i - 1] : refmultEng[i - 1]) + "s ");
                    } else {
                        result.append(String.valueOf(new Nombre(val, this.language).getText()) + " " + (this.language == FR ? refmult[i - 1] : refmultEng[i - 1]) + " ");
                    }
                }
                cumul += val * puissancei;
                --i;
            }
            int val = this.nb % 1000;
            if (val > 0) {
                result.append(new Nombre(val, this.language).getText());
            }
        }
        return result.toString().trim();
    }

    String getText(String r) {
        return String.valueOf(r);
    }
}

