/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.openconcerto.utils.StreamUtils;

public class MessageDigestUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String asHex(byte[] hash) {
        return MessageDigestUtils.toString(hash, HEX_CHARS);
    }

    public static String toString(byte[] hash, char[] chars) {
        char[] buf = new char[hash.length * 2];
        int i = 0;
        int x = 0;
        while (i < hash.length) {
            buf[x++] = chars[hash[i] >>> 4 & 0xF];
            buf[x++] = chars[hash[i] & 0xF];
            ++i;
        }
        return new String(buf);
    }

    public static byte[] fromHex(String hash) {
        byte[] buf = new byte[hash.length() / 2];
        int i = 0;
        while (i < buf.length) {
            buf[i] = (byte)Integer.parseInt(hash.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return buf;
    }

    public static byte[] int2bytes(int integer) {
        byte[] byteStr = new byte[]{(byte)(integer >>> 24), (byte)(integer >>> 16 & 0xFF), (byte)(integer >>> 8 & 0xFF), (byte)(integer & 0xFF)};
        return byteStr;
    }

    public static int bytes2int(byte[] buf) {
        return buf[0] << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    public static String getHashString(MessageDigest md) {
        return MessageDigestUtils.asHex(md.digest());
    }

    public static String getHashString(String algo, byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algo);
        return MessageDigestUtils.getHashString(md, data);
    }

    public static String getHashString(MessageDigest md, byte[] data) {
        md.update(data);
        return MessageDigestUtils.getHashString(md);
    }

    public static String getHashString(MessageDigest md, InputStream ins) throws IOException {
        DigestOutputStream out = new DigestOutputStream(StreamUtils.NULL_OS, md);
        StreamUtils.copy(ins, out);
        out.close();
        return MessageDigestUtils.getHashString(md);
    }

    public static String getMD5(File f) throws IOException {
        FileInputStream ins = new FileInputStream(f);
        try {
            String string = MessageDigestUtils.getHashString(MessageDigestUtils.getMD5(), ins);
            return string;
        }
        finally {
            ((InputStream)ins).close();
        }
    }

    public static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 is part of the standard vm", e);
        }
    }

    private MessageDigestUtils() {
    }
}

