/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.JImage;

public class ExceptionHandler
extends RuntimeException {
    private static final String ILM_CONTACT = "http://www.ilm-informatique.fr/contact";
    private static String ForumURL = null;
    private final Component comp;
    private static boolean forceUI;

    public static void setForumURL(String url) {
        ForumURL = url;
    }

    private static void copyToClipboard(String s) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(s);
        clipboard.setContents(data, data);
    }

    public static RuntimeException handle(Component comp, String msg, Throwable originalExn) {
        return new ExceptionHandler(comp, msg, originalExn, false);
    }

    public static RuntimeException handle(String msg, Throwable originalExn) {
        return ExceptionHandler.handle(null, msg, originalExn);
    }

    public static RuntimeException handle(String msg) {
        return ExceptionHandler.handle(msg, null);
    }

    public static RuntimeException die(String msg, Throwable originalExn) {
        return new ExceptionHandler(null, msg, originalExn);
    }

    public static RuntimeException die(String msg) {
        return ExceptionHandler.die(msg, null);
    }

    private static Logger getLogger() {
        return Logger.getLogger("global");
    }

    public static void setForceUI(boolean forceUI) {
        ExceptionHandler.forceUI = forceUI;
    }

    private void display(final boolean error) {
        final String msg = this.getMessage();
        if (error) {
            ExceptionHandler.getLogger().severe(this.getTrace());
        } else if (this.getCause() != null) {
            ExceptionHandler.getLogger().info(this.getTrace());
        }
        if (!GraphicsEnvironment.isHeadless() || forceUI) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.showMsg(msg, error);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExceptionHandler.this.showMsg(msg, error);
                    }
                });
            }
        }
    }

    protected final void showMsg(String msg, final boolean quit) {
        boolean browseSupported;
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        JImage im = new JImage(new ImageIcon(this.getClass().getResource("error.png")));
        JLabel l = new JLabel("Une erreur est survenue");
        l.setFont(l.getFont().deriveFont(1));
        JLabel lError = new JLabel(msg);
        JTextArea textArea = new JTextArea();
        textArea.setFont(textArea.getFont().deriveFont(11.0f));
        c.gridheight = 3;
        p.add((Component)im, c);
        c.insets = new Insets(2, 4, 2, 4);
        c.gridheight = 1;
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        p.add((Component)l, c);
        ++c.gridy;
        p.add((Component)lError, c);
        ++c.gridy;
        p.add((Component)new JLabel("Il s'agit probablement d'une mauvaise configuration ou installation du logiciel."), c);
        c.gridx = 0;
        c.gridwidth = 3;
        ++c.gridy;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridx = 1;
        ++c.gridy;
        c.fill = 0;
        c.anchor = 13;
        final Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        boolean bl = browseSupported = desktop != null && desktop.isSupported(Desktop.Action.BROWSE);
        if (ForumURL != null) {
            AbstractAction communityAction = browseSupported ? new AbstractAction("Consulter le forum"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        desktop.browse(new URI(ForumURL));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            } : new AbstractAction("Copier l'adresse du forum"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionHandler.copyToClipboard(ForumURL);
                }
            };
            p.add((Component)new JButton(communityAction), c);
        }
        c.weightx = 0.0;
        ++c.gridx;
        AbstractAction supportAction = browseSupported ? new AbstractAction("Contacter l'assistance"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    desktop.browse(URI.create(ExceptionHandler.ILM_CONTACT));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        } : new AbstractAction("Copier l'adresse de l'assistance"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionHandler.copyToClipboard(ExceptionHandler.ILM_CONTACT);
            }
        };
        p.add((Component)new JButton(supportAction), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        p.add((Component)new JSeparator(), c);
        c.gridx = 0;
        c.gridwidth = 3;
        ++c.gridy;
        c.insets = new Insets(2, 4, 2, 4);
        p.add((Component)new JLabel("D\u00e9tails de l'erreur:"), c);
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridy;
        String message = this.getCause() == null ? null : this.getCause().getMessage();
        message = message == null ? msg : String.valueOf(msg) + "\n\n" + message;
        message = String.valueOf(message) + "\n";
        message = String.valueOf(message) + this.getTrace();
        textArea.setText(message);
        textArea.setEditable(false);
        JScrollPane scroll = new JScrollPane(textArea);
        scroll.setHorizontalScrollBarPolicy(32);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.getViewport().setMinimumSize(new Dimension(200, 300));
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)scroll, c);
        ++c.gridy;
        c.fill = 0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 4, 2, 4);
        JButton buttonClose = new JButton("Fermer");
        p.add((Component)buttonClose, c);
        Window window = this.comp == null ? null : SwingUtilities.getWindowAncestor(this.comp);
        final JDialog f = window instanceof Frame ? new JDialog((Frame)window, "Erreur", true) : new JDialog((Dialog)window, "Erreur", true);
        f.setContentPane(p);
        f.pack();
        f.setSize(580, 680);
        f.setMinimumSize(new Dimension(380, 380));
        f.setLocationRelativeTo(this.comp);
        final ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (quit) {
                    System.exit(1);
                } else {
                    f.dispose();
                }
            }
        };
        buttonClose.addActionListener(al);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                al.actionPerformed(null);
            }
        });
        f.setVisible(true);
    }

    private String getTrace() {
        return ExceptionUtils.getStackTrace(this);
    }

    private ExceptionHandler(Component comp, String msg, Throwable cause) {
        this(comp, msg, cause, true);
    }

    private ExceptionHandler(Component comp, String msg, Throwable cause, boolean quit) {
        super(msg, cause);
        this.comp = comp;
        this.display(quit);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        ExceptionHandler.handle("Fichier de configuration corrompu", new IllegalStateException("Id manquant"));
    }
}

