/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.openconcerto.utils.JImage;

public class DragUtils {
    private static JComponent source;
    private static Point click;
    private static JImage dragged;

    static {
        DragUtils.init();
    }

    private static void init() {
        source = null;
        click = null;
        dragged = null;
    }

    public static boolean beingDragged(JComponent comp) {
        return comp == source;
    }

    public static synchronized void beginDrag(JComponent comp, Point click) {
        if (source != null) {
            throw new IllegalStateException("already dragging");
        }
        source = comp;
        DragUtils.click = click;
        DragUtils.addToDragLayer(DragUtils.getImage());
    }

    public static synchronized void beginDrag(JComponent comp, Point click, Image img) {
        if (source != null) {
            throw new IllegalStateException("already dragging");
        }
        source = comp;
        DragUtils.click = new Point();
        DragUtils.addToDragLayer(img);
    }

    private static Image getImage() {
        BufferedImage img = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        Graphics2D gr = img.createGraphics();
        AlphaComposite ac = AlphaComposite.getInstance(2, 0.7f);
        gr.setComposite(ac);
        source.print(gr);
        return img;
    }

    private static void addToDragLayer(Image img) {
        Point rootPanePoint = SwingUtilities.convertPoint(source, new Point(), source.getRootPane());
        dragged = new JImage(img);
        dragged.setLocation(rootPanePoint);
        dragged.setSize(dragged.getPreferredSize());
        source.getRootPane().getLayeredPane().add((Component)dragged, JLayeredPane.DRAG_LAYER);
    }

    public static void dragTo(Point p) {
        JRootPane root = source.getRootPane();
        JLayeredPane lp = root.getLayeredPane();
        Point rootPanePoint = SwingUtilities.convertPoint(source, p, lp);
        dragged.setLocation(rootPanePoint.x - DragUtils.click.x, rootPanePoint.y - DragUtils.click.y);
    }

    public static void endDrag() {
        if (dragged != null) {
            JLayeredPane lp = (JLayeredPane)dragged.getParent();
            lp.remove(dragged);
            lp.validate();
            lp.repaint();
            DragUtils.init();
        }
    }
}

