/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Comparator;
import java.util.List;
import org.openconcerto.utils.cc.ITransformer;

public class CompareUtils {
    public static final int compareIntNumbers(Number n1, Number n2) {
        return CompareUtils.compareLong(n1.longValue(), n2.longValue());
    }

    public static final int compareInt(int int1, int int2) {
        if (int1 < int2) {
            return -1;
        }
        if (int1 == int2) {
            return 0;
        }
        return 1;
    }

    public static final int compareLong(long int1, long int2) {
        if (int1 < int2) {
            return -1;
        }
        if (int1 == int2) {
            return 0;
        }
        return 1;
    }

    public static final <T> Comparator<T> createComparator(final List<? extends Comparator<T>> comparators) {
        return new Comparator<T>(){

            public String toString() {
                return "CompareUtils comparator with " + comparators;
            }

            @Override
            public int compare(T o1, T o2) {
                int result = 0;
                int i = 0;
                while (i < comparators.size() && result == 0) {
                    Comparator transf = (Comparator)comparators.get(i);
                    result = transf.compare(o1, o2);
                    ++i;
                }
                return result;
            }
        };
    }

    public static final boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static final <T> boolean equals(List<T> l1, List<T> l2, Equalizer<? super T> comp) {
        return CompareUtils.compare(l1, l2, comp, null) == null;
    }

    public static final <T> String compare(List<T> l1, List<T> l2, Equalizer<? super T> comp, ITransformer<? super T, String> toString) {
        int size = l1.size();
        if (size != l2.size()) {
            return "unequal size";
        }
        int i = 0;
        while (i < size) {
            T o2;
            T o1 = l1.get(i);
            if (!comp.equals(o1, o2 = l2.get(i))) {
                String s1 = toString == null ? String.valueOf(o1) : toString.transformChecked(o1);
                String s2 = toString == null ? String.valueOf(o2) : toString.transformChecked(o2);
                return "unequal at " + i + ": " + s1 + " != " + s2;
            }
            ++i;
        }
        return null;
    }

    public static interface Equalizer<T> {
        public boolean equals(T var1, T var2);
    }
}

