/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.collections.TransformerUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.Transformer;

public class CollectionUtils
extends org.apache.commons.collections.CollectionUtils {
    private static final Pattern COMMA = Pattern.compile("\\p{Space}*,\\p{Space}*");

    public static final <E> String join(Collection<E> c, String sep, ITransformer<? super E, ?> tf) {
        int size = c.size();
        if (size == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer(size * 4);
        if (c instanceof RandomAccess && c instanceof List) {
            List list = (List)c;
            int i = 0;
            while (i < size) {
                res.append(tf.transformChecked(list.get(i)));
                if (i < size - 1) {
                    res.append(sep);
                }
                ++i;
            }
        } else {
            Iterator<E> iter = c.iterator();
            while (iter.hasNext()) {
                E elem = iter.next();
                res.append(tf.transformChecked(elem));
                if (!iter.hasNext()) continue;
                res.append(sep);
            }
        }
        return res.toString();
    }

    public static <T> String join(Collection<T> c, String sep) {
        return CollectionUtils.join(c, sep, Transformer.nopTransformer());
    }

    public static <T, U, C extends Collection<? super U>> C transformAndFilter(Collection<T> c, final ITransformer<? super T, U> transf, final IPredicate<? super U> filter, final C res) {
        CollectionUtils.iterate(c, new IClosure<T>(){

            @Override
            public void executeChecked(T input) {
                Object item = transf.transformChecked(input);
                if (filter.evaluateChecked(item)) {
                    res.add(item);
                }
            }
        });
        return res;
    }

    public static <T> void iterate(Collection<T> c, IClosure<T> cl) {
        if (c instanceof RandomAccess && c instanceof List) {
            List list = (List)c;
            int size = c.size();
            int i = 0;
            while (i < size) {
                cl.executeChecked(list.get(i));
                ++i;
            }
        } else {
            Iterator<T> iter = c.iterator();
            while (iter.hasNext()) {
                cl.executeChecked(iter.next());
            }
        }
    }

    public static List<String> split(String s) {
        return CollectionUtils.split(s, COMMA);
    }

    public static List<String> split(String s, String sep) {
        return CollectionUtils.split(s, Pattern.compile(sep));
    }

    public static List<String> split(String s, Pattern pattern) {
        return s.length() == 0 ? Collections.emptyList() : Arrays.asList(pattern.split(s));
    }

    public static int getValidIndex(List<?> l, int i) {
        if (i > l.size()) {
            return l.size();
        }
        if (i >= 0) {
            return i;
        }
        if (l.size() + i <= 0) {
            return 0;
        }
        return l.size() + i;
    }

    public static void delete(List<?> l, int from, int to) {
        if (!l.isEmpty()) {
            l.subList(CollectionUtils.getValidIndex(l, from), CollectionUtils.getValidIndex(l, to) + 1).clear();
        }
    }

    public static void delete(List<?> l, int from) {
        CollectionUtils.delete(l, from, -1);
    }

    public static <T, C extends Collection<? super T>> C select(Collection<T> inputCollection, IPredicate<? super T> predicate, C outputCollection) {
        org.apache.commons.collections.CollectionUtils.select(inputCollection, predicate, outputCollection);
        return outputCollection;
    }

    public static final SortedMap organize(Collection col, List<? extends org.apache.commons.collections.Transformer> propExtractors, List<? extends Comparator> propComp, Comparator itemOrdering) {
        if (propExtractors.size() == 0) {
            throw new IllegalArgumentException("Empty property extractors");
        }
        if (propComp == null) {
            propComp = Collections.nCopies(propExtractors.size(), null);
        } else if (propExtractors.size() != propComp.size()) {
            throw new IllegalArgumentException("Size mismatch between " + propExtractors + " and " + propComp);
        }
        TreeMap res = new TreeMap(propComp.get(0));
        for (Object item : col) {
            Map m = res;
            int i = 0;
            while (i < propExtractors.size() - 1) {
                org.apache.commons.collections.Transformer extractor = propExtractors.get(i);
                Object property = extractor.transform(item);
                TreeMap newM = (TreeMap)m.get(property);
                if (newM == null) {
                    newM = new TreeMap(propComp.get(i + 1));
                    m.put(property, newM);
                }
                m = newM;
                ++i;
            }
            Object property = propExtractors.get(propExtractors.size() - 1).transform(item);
            TreeSet s = (TreeSet)m.get(property);
            if (s == null) {
                s = new TreeSet(itemOrdering);
                m.put(property, s);
            }
            s.add(item);
        }
        return res;
    }

    public static final List flatten(Map hierarchy, org.apache.commons.collections.Transformer itemTransf) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Object obj : hierarchy.keySet()) {
            res.add(obj);
            Object value = hierarchy.get(obj);
            if (value instanceof Map) {
                res.addAll(CollectionUtils.flatten((Map)value, itemTransf));
                continue;
            }
            if (value instanceof Collection) {
                Collection items = (Collection)value;
                for (Object item : items) {
                    res.add(itemTransf.transform(item));
                }
                continue;
            }
            throw new IllegalArgumentException("Illegal value: " + value);
        }
        return res;
    }

    public static final List flatten(Map hierarchy) {
        return CollectionUtils.flatten(hierarchy, TransformerUtils.nopTransformer());
    }

    public static <K, V> Tuple2<List<K>, List<V>> mapToLists(Map<K, V> map) {
        ArrayList<K> keys = new ArrayList<K>(map.size());
        ArrayList<V> vals = new ArrayList<V>(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            keys.add(e.getKey());
            vals.add(e.getValue());
        }
        return Tuple2.create(keys, vals);
    }

    public static <K, V> Map<K, V> addIfNotPresent(Map<K, V> map, Map<? extends K, ? extends V> toAdd) {
        for (Map.Entry<K, V> e : toAdd.entrySet()) {
            if (map.containsKey(e.getKey())) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    public static <E> List<Integer> getIndexesChanged(List<E> oldList, List<E> newList) {
        ArrayList<E> shorter;
        ArrayList<E> longer;
        if (newList.size() > oldList.size()) {
            longer = new ArrayList<E>(newList);
            shorter = new ArrayList<E>(oldList);
        } else {
            longer = new ArrayList<E>(oldList);
            shorter = new ArrayList<E>(newList);
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        int offset = 0;
        while (shorter.size() > 0) {
            if (longer.size() < shorter.size()) {
                throw new IllegalStateException(shorter + " is not a sublist of " + longer);
            }
            if (CompareUtils.equals(shorter.get(0), longer.get(0))) {
                shorter.remove(0);
                longer.remove(0);
            } else {
                longer.remove(0);
                res.add(offset);
            }
            ++offset;
        }
        int i = 0;
        while (i < longer.size()) {
            res.add(i + offset);
            ++i;
        }
        return res;
    }

    public static List<int[]> aggregate(Collection<? extends Number> ints) {
        ArrayList<int[]> res = new ArrayList<int[]>();
        int[] currentInterval = null;
        for (Number number : ints) {
            int index = number.intValue();
            if (currentInterval == null || index != currentInterval[1] + 1) {
                currentInterval = new int[]{index, currentInterval[0]};
                res.add(currentInterval);
                continue;
            }
            currentInterval[1] = index;
        }
        return res;
    }

    public static <T> Set<T> contains(Set<T> col1, Set<T> col2) {
        if (col1.containsAll(col2)) {
            return null;
        }
        HashSet<T> names = new HashSet<T>(col2);
        names.removeAll(col1);
        return names;
    }

    public static <U, T extends U> List<T> castToList(U[] array, Class<T> clazz) throws ClassCastException {
        ArrayList<T> res = new ArrayList<T>(array.length);
        U[] UArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            U item = UArray[n2];
            res.add(clazz.cast(item));
            ++n2;
        }
        return res;
    }

    public static <T> int equalsFromEnd(List<T> a, List<T> b) {
        return CollectionUtils.equals(a, b, true, null);
    }

    public static <T> int equalsFromStart(List<T> a, List<T> b) {
        return CollectionUtils.equals(a, b, false, null);
    }

    public static final <A, B> int equals(List<A> a, List<B> b, boolean fromEnd, ITransformer<A, B> transf) {
        int sizeA = a.size();
        int sizeB = b.size();
        int lastI = Math.min(sizeA, sizeB);
        int i = 0;
        while (i < lastI) {
            B itemB;
            A itemA = a.get(fromEnd ? sizeA - 1 - i : i);
            if (!CompareUtils.equals(transf == null ? itemA : transf.transformChecked(itemA), itemB = b.get(fromEnd ? sizeB - 1 - i : i))) {
                return i;
            }
            ++i;
        }
        return lastI;
    }

    public static <T> Collection<T> intersection(Collection<T> a, Collection<T> b) {
        return org.apache.commons.collections.CollectionUtils.intersection(a, b);
    }

    public static <T> Set<T> inter(Set<T> a, Set<T> b) {
        return CollectionUtils.interSubtype(a, b);
    }

    public static <T> Set<? extends T> interSubtype(Set<? extends T> a, Set<? extends T> b) {
        if (a == b) {
            return a;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.size() > b.size()) {
            return CollectionUtils.interSubtype(b, a);
        }
        HashSet<T> res = new HashSet<T>();
        for (T item : a) {
            if (!b.contains(item)) continue;
            res.add(item);
        }
        return res;
    }

    public static <T> Set<T> inter(Set<T> ... sets) {
        return CollectionUtils.inter(Arrays.asList(sets));
    }

    public static <T> Set<T> inter(List<Set<T>> sets) {
        ArrayList<Set<T>> mutable = new ArrayList<Set<T>>(sets.size());
        for (Set<T> s : sets) {
            if (s == null) continue;
            mutable.add(s);
        }
        if (mutable.isEmpty()) {
            return null;
        }
        if (mutable.size() == 1) {
            return (Set)mutable.get(0);
        }
        int indexMin = CollectionUtils.indexOfMinSize(mutable);
        if (indexMin != 0) {
            mutable.add(0, (Set)mutable.remove(indexMin));
            return CollectionUtils.inter(mutable);
        }
        if (((Set)mutable.get(0)).isEmpty()) {
            return Collections.emptySet();
        }
        mutable.add(0, CollectionUtils.inter((Set)mutable.remove(0), (Set)mutable.remove(0)));
        return CollectionUtils.inter(mutable);
    }

    private static final <T> int indexOfMinSize(List<Set<T>> sets) {
        if (sets.isEmpty()) {
            throw new IllegalArgumentException("empty sets");
        }
        int res = 0;
        int i = 1;
        while (i < sets.size()) {
            if (sets.get(i).size() < sets.get(res).size()) {
                res = i;
            }
            ++i;
        }
        return res;
    }

    public static <T> Set<T> union(Set<? extends T> a, Set<? extends T> b) {
        HashSet<T> res = new HashSet<T>(a);
        if (a != b) {
            res.addAll(b);
        }
        return res;
    }

    public static <T> Collection<T> subtract(Collection<T> a, Collection<? extends T> b) {
        return org.apache.commons.collections.CollectionUtils.subtract(a, b);
    }

    public static <T> Collection<T> substract(Collection<T> a, Collection<? extends T> b) {
        return org.apache.commons.collections.CollectionUtils.subtract(a, b);
    }

    public static <T> T getSole(List<T> l) {
        return l.size() == 1 ? (T)l.get(0) : null;
    }

    public static <T> T getSole(Collection<T> l) {
        return l.size() == 1 ? (T)l.iterator().next() : null;
    }

    public static <T> T getFirst(Collection<T> l) {
        return l.size() > 0 ? (T)l.iterator().next() : null;
    }

    public static <T> T getFirst(List<T> l) {
        return CollectionUtils.getNoExn(l, 0);
    }

    public static <T> T getLast(List<T> l) {
        return CollectionUtils.getNoExn(l, l.size() - 1);
    }

    public static <T> T getNoExn(List<T> l, int index) {
        return index >= 0 && index < l.size() ? (T)l.get(index) : null;
    }

    public static <T> Set<T> createSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <K, V> Map<K, V> createMap(K key, V val, K key2, V val2) {
        HashMap<K, V> res = new HashMap<K, V>();
        res.put(key, val);
        res.put(key2, val2);
        return res;
    }

    public static <K, V> Map<K, V> createMap(K key, V val, K key2, V val2, K key3, V val3) {
        Map<K, V> res = CollectionUtils.createMap(key, val, key2, val2);
        res.put(key3, val3);
        return res;
    }

    public static <K, V> Map<K, V> createMap(Collection<? extends K> keys) {
        return CollectionUtils.fillMap(keys instanceof List ? new LinkedHashMap(keys.size()) : new HashMap(keys.size()), keys);
    }

    public static <K, V, M extends Map<K, V>> M fillMap(M m, Collection<? extends K> keys) {
        for (K key : keys) {
            m.put(key, null);
        }
        return m;
    }
}

