/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.openconcerto.utils.CopyUtils;
import org.openconcerto.utils.ExceptionUtils;

public class CollectionMap<K, V>
extends MultiHashMap {
    private static final int DEFAULT_CAPACITY = 16;
    private final Class<? extends Collection<V>> collectionClass;
    private final Collection<V> collectionSpecimen;

    public static <K, V> CollectionMap<K, V> singleton(K key, Collection<V> values) {
        CollectionMap<K, V> res = new CollectionMap<K, V>();
        res.putAll(key, values);
        return res;
    }

    public static <K, V> CollectionMap<K, V> singleton(K key, V ... values) {
        return CollectionMap.singleton(key, Arrays.asList(values));
    }

    public static <K, V> CollectionMap<K, V> singleton(K key, V value) {
        return CollectionMap.singleton(key, Collections.singleton(value));
    }

    public CollectionMap() {
        this(ArrayList.class);
    }

    public CollectionMap(Class aCollectionClass) {
        this(aCollectionClass, 16);
    }

    public CollectionMap(int initialCapacity) {
        this((Class)null, initialCapacity);
    }

    public CollectionMap(Class aCollectionClass, int initialCapacity) {
        super(initialCapacity);
        this.collectionClass = aCollectionClass;
        this.collectionSpecimen = null;
    }

    public CollectionMap(Collection<V> collectionSpecimen) {
        this(collectionSpecimen, 16);
    }

    public CollectionMap(Collection<V> collectionSpecimen, int initialCapacity) {
        super(initialCapacity);
        this.collectionClass = null;
        if (!(collectionSpecimen instanceof Cloneable)) {
            throw new IllegalArgumentException(collectionSpecimen + " not a cloneable.");
        }
        this.collectionSpecimen = CopyUtils.copy(collectionSpecimen);
        this.collectionSpecimen.clear();
    }

    public Collection<V> getNonNull(K key) {
        Collection<V> res = this.getNull(key);
        return res == null ? this.createCollection(res) : res;
    }

    public Collection<V> getNull(K key) {
        return (Collection)this.get(key);
    }

    @Override
    public Collection<V> createCollection(Collection coll) {
        if (this.collectionClass != null) {
            try {
                if (coll == null) {
                    return this.collectionClass.newInstance();
                }
                return this.collectionClass.getConstructor(Collection.class).newInstance(coll);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.collectionSpecimen != null) {
            try {
                Collection<V> res = CopyUtils.copy(this.collectionSpecimen);
                if (coll != null) {
                    res.addAll(coll);
                }
                return res;
            }
            catch (Exception e) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "clone() failed", e);
            }
        }
        return super.createCollection(coll);
    }

    public Class getCollectionClass() {
        return this.collectionClass;
    }

    public void merge(MultiMap mm) {
        for (Map.Entry entry : mm.entrySet()) {
            Collection coll = (Collection)entry.getValue();
            Collection<V> newColl = this.createCollection(coll);
            this.putAll(entry.getKey(), newColl);
        }
    }

    @Override
    public void putAll(Map mapToCopy) {
        if (mapToCopy instanceof MultiMap) {
            this.merge((MultiMap)mapToCopy);
        } else {
            super.putAll(mapToCopy);
        }
    }

    public boolean putAll(K key, V ... values) {
        return this.putAll((Object)key, Arrays.asList(values));
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return super.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return super.keySet();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    public Collection<V> remove(Object key) {
        return (Collection)super.remove(key);
    }
}

