/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.valuewrapper.format;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import org.openconcerto.ui.component.text.TextComponentUtils;
import org.openconcerto.ui.filters.FormatFilter;
import org.openconcerto.ui.valuewrapper.BaseValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.ui.valuewrapper.format.FilterFormatValueWrapper;
import org.openconcerto.ui.valuewrapper.format.VWFormatValueWrapper;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidObjectCombiner;

public abstract class FormatValueWrapper<T>
extends BaseValueWrapper<T> {
    private final JComponent comp;
    private final FormatFilter formatFilter;
    private final ValidObjectCombiner comb;

    public static <Z> FormatValueWrapper<Z> create(JComponent o, Class<Z> c) {
        Document doc = TextComponentUtils.getDocument(o);
        if (doc != null) {
            return new FilterFormatValueWrapper<Z>(o, (AbstractDocument)doc, c);
        }
        if (o instanceof ValueWrapper) {
            return new VWFormatValueWrapper<Z>((ValueWrapper)((Object)o), c);
        }
        throw new IllegalArgumentException("" + o);
    }

    private static boolean isNull(String text) {
        return text == null || text.length() == 0;
    }

    protected FormatValueWrapper(JComponent b, final FormatFilter f) {
        this.comp = b;
        this.formatFilter = f;
        this.comb = ValidObjectCombiner.create(this, this.comp, new ValidObject(){
            private final List<ValidListener> listeners = new ArrayList<ValidListener>();
            {
                FormatValueWrapper.this.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        this.fireValidChange();
                    }
                });
            }

            private void fireValidChange() {
                for (ValidListener l : this.listeners) {
                    l.validChange(this, this.isValidated());
                }
            }

            @Override
            public void addValidListener(ValidListener l) {
                this.listeners.add(l);
            }

            @Override
            public void removeValidListener(ValidListener l) {
                this.listeners.remove(l);
            }

            @Override
            public String getValidationText() {
                return f.getValidationText(FormatValueWrapper.this.getText());
            }

            @Override
            public boolean isValidated() {
                return FormatValueWrapper.this.isFormatValidated();
            }
        });
        this.comb.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, boolean newValue) {
                FormatValueWrapper.this.firePropertyChange();
            }
        });
    }

    @Override
    public final JComponent getComp() {
        return this.comp;
    }

    public final Format getFormat() {
        return this.formatFilter.getFormat();
    }

    @Override
    public final T getValue() {
        String text;
        block3: {
            text = this.getText();
            try {
                if (!FormatValueWrapper.isNull(text) && !this.formatFilter.isPartialValid(text)) break block3;
            }
            catch (ParseException e) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "unable to parse " + text, e);
            }
            return null;
        }
        return (T)this.getFormat().parseObject(text);
    }

    @Override
    public final void setValue(T val) {
        this.setText(val == null ? "" : this.formatFilter.format(val));
    }

    protected abstract String getText();

    protected abstract void setText(String var1);

    @Override
    public final boolean isValidated() {
        return this.comb.isValidated();
    }

    private final boolean isFormatValidated() {
        String text = this.getText();
        return FormatValueWrapper.isNull(text) || this.formatFilter.isCompleteValid(text);
    }

    @Override
    public String getValidationText() {
        return this.comb.getValidationText();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " on " + this.getComp();
    }
}

