/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.valuewrapper;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidListener;

public final class ValueChangeSupport<T> {
    public static final String INVALID_VALUE = "invalidValue";
    private final ValueWrapper<T> vw;
    private final PropertyChangeSupport supp;
    private final List<ValidListener> validListeners;
    private Boolean valid;
    private boolean signalInvalid;

    public ValueChangeSupport(ValueWrapper<T> vw) {
        this.vw = vw;
        this.validListeners = new ArrayList<ValidListener>();
        this.supp = new PropertyChangeSupport(vw);
        this.valid = null;
        this.signalInvalid = true;
    }

    public final void fireValueChange() {
        boolean newValid = this.vw.isValidated();
        if (newValid) {
            this.supp.firePropertyChange("value", null, this.vw.getValue());
        } else if (this.signalInvalid) {
            this.supp.firePropertyChange(INVALID_VALUE, null, null);
        }
        this.setValid(newValid);
    }

    public final void fireValidChange() {
        this.setValid(this.vw.isValidated());
    }

    private final void setValid(Boolean newValid) {
        if (!newValid.equals(this.valid)) {
            this.valid = newValid;
            for (ValidListener l : this.validListeners) {
                l.validChange(this.vw, this.valid);
            }
        }
    }

    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    public void rmValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public void addValidListener(ValidListener l) {
        this.validListeners.add(l);
    }

    public void removeValidListener(ValidListener l) {
        this.validListeners.remove(l);
    }

    public boolean isSignalInvalid() {
        return this.signalInvalid;
    }

    public void setSignalInvalid(boolean signalInvalid) {
        this.signalInvalid = signalInvalid;
    }
}

