/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.valuewrapper;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import org.openconcerto.ui.valuewrapper.BaseValueWrapper;

public class JFormattedTextFieldValueWrapper<Z>
extends BaseValueWrapper<Z> {
    private final JFormattedTextField tf;
    private final Class<Z> c;

    public static <Z> boolean isCompatible(JFormattedTextField comp, Class<Z> c) {
        if (!(comp.getFormatter() instanceof DefaultFormatter)) {
            return false;
        }
        DefaultFormatter formatter = (DefaultFormatter)comp.getFormatter();
        return formatter.getValueClass() == null || c.isAssignableFrom(formatter.getValueClass());
    }

    JFormattedTextFieldValueWrapper(JFormattedTextField comp, Class<Z> c) {
        this.tf = comp;
        Class<?> vc = this.getFormatter().getValueClass();
        if (vc == null) {
            this.getFormatter().setValueClass(c);
        } else if (!c.isAssignableFrom(vc)) {
            throw new IllegalArgumentException("value class :" + vc + " not a subclass of " + c);
        }
        this.c = c;
        this.tf.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("value")) {
                    JFormattedTextFieldValueWrapper.this.firePropertyChange();
                } else if (evt.getPropertyName().equals("editValid")) {
                    JFormattedTextFieldValueWrapper.this.supp.fireValidChange();
                }
            }
        });
    }

    private final DefaultFormatter getFormatter() {
        return (DefaultFormatter)this.tf.getFormatter();
    }

    @Override
    public JComponent getComp() {
        return this.tf;
    }

    @Override
    public boolean isValidated() {
        return this.tf.isEditValid();
    }

    @Override
    public void setValue(Z val) {
        this.tf.setValue(val);
    }

    @Override
    public Z getValue() {
        return this.c.cast(this.tf.getValue());
    }
}

