/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.tips;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.tips.Tip;
import org.openconcerto.utils.JImage;

public class TipsFrame
extends JFrame {
    private static final int H = 330;
    private final List<Tip> tips = new ArrayList<Tip>();
    private int currentIndex;
    private JComponent currentPanel = new JPanel();
    private GridBagConstraints constraintPanel;

    public TipsFrame(boolean checked) {
        this.setTitle("Astuces");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.WHITE);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JImage img = new JImage(TipsFrame.class.getResource("bg_tips.png"));
        c.gridheight = 2;
        c.anchor = 12;
        panel.add((Component)img, c);
        c.gridheight = 2;
        ++c.gridx;
        c.fill = 1;
        c.anchor = 12;
        panel.add((Component)new JSeparator(1), c);
        ++c.gridx;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel comp = new JLabel("Le saviez-vous ?");
        c.gridheight = 1;
        comp.setFont(comp.getFont().deriveFont(18.0f));
        panel.add((Component)comp, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 1;
        this.currentPanel.setBackground(Color.WHITE);
        this.currentPanel.setMinimumSize(new Dimension(480, 330));
        this.currentPanel.setPreferredSize(new Dimension(480, 330));
        this.constraintPanel = (GridBagConstraints)c.clone();
        panel.add((Component)this.currentPanel, c);
        c.gridx = 0;
        c.gridy += 2;
        c.gridwidth = 3;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        JSeparator sep = new JSeparator(0);
        panel.add((Component)sep, c);
        ++c.gridy;
        c.anchor = 13;
        JPanel toolbar = new JPanel(new FlowLayout(2));
        final JCheckBox checkBox = new JCheckBox("Afficher les astuces au d\u00e9marrage");
        checkBox.setSelected(checked);
        toolbar.add(checkBox);
        JButton buttonPrecedent = new JButton("Pr\u00e9c\u00e9dent");
        toolbar.add(buttonPrecedent);
        buttonPrecedent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int c = (TipsFrame.this.currentIndex - 1) % TipsFrame.this.tips.size();
                TipsFrame.this.setCurrentTip(c);
            }
        });
        JButton buttonSuivant = new JButton("Suivant");
        buttonSuivant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int c = (TipsFrame.this.currentIndex + 1) % TipsFrame.this.tips.size();
                TipsFrame.this.setCurrentTip(c);
            }
        });
        toolbar.add(buttonSuivant);
        panel.add((Component)toolbar, c);
        this.setContentPane(panel);
        this.setResizable(false);
        this.pack();
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TipsFrame.this.checkBoxModified(checkBox.isSelected());
            }
        });
    }

    protected void checkBoxModified(boolean selected) {
    }

    public void addTip(Tip t) {
        this.tips.add(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentTip(int i) {
        if (i < 0) {
            i = this.tips.size() - 1;
        }
        this.currentIndex = i % this.tips.size();
        Object object = this.getTreeLock();
        synchronized (object) {
            this.remove(this.currentPanel);
            this.invalidate();
            this.currentPanel = this.tips.get(i).getPanel();
            this.currentPanel.setMinimumSize(new Dimension(480, 330));
            this.currentPanel.setPreferredSize(new Dimension(480, 330));
            this.add((Component)this.currentPanel, this.constraintPanel);
            this.validateTree();
        }
        this.repaint();
    }

    public static void main(String[] args) {
        Tip t1 = new Tip();
        t1.addText("Les fonctions de gestion courante se trouvent dans le menu 'Saisie'.");
        t1.addText("Vous y trouverez les interfaces de cr\u00e9ation :");
        t1.addText("- des devis et factures");
        t1.addText("- des achats, livraisons et mouvements stocks");
        t1.addText("- des commandes et bons de r\u00e9ception");
        Tip t2 = new Tip();
        t1.addText("Le logiciel int\u00e8gre un module de cartographie.");
        TipsFrame f = new TipsFrame(true);
        f.addTip(t1);
        f.setCurrentTip(0);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

