/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.tips;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.JImage;

public class Tip {
    private final List<Object> items = new ArrayList<Object>();

    public void addText(String text) {
        this.items.add(text);
    }

    public void addImage(Image image) {
        this.items.add(image);
    }

    public void addImage(ImageIcon icon) {
        this.items.add(icon.getImage());
    }

    public void addImage(URL url) {
        this.addImage(new ImageIcon(url));
    }

    public void addImage(JComponent component) {
        this.items.add(component);
    }

    public JComponent getPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        DefaultGridBagConstraints contraint = new DefaultGridBagConstraints();
        contraint.anchor = 18;
        int size = this.items.size();
        contraint.weightx = 1.0;
        int i = 0;
        while (i < size) {
            Object item = this.items.get(i);
            if (item instanceof String) {
                panel.add((Component)new JLabel((String)item), contraint);
            } else if (item instanceof JComponent) {
                panel.add((Component)((JComponent)item), contraint);
            } else if (item instanceof Image) {
                panel.add((Component)new JImage((Image)item), contraint);
            } else {
                throw new IllegalStateException(item + " cannot be added");
            }
            ++contraint.gridy;
            ++i;
        }
        ++contraint.gridy;
        contraint.weighty = 1.0;
        JPanel comp = new JPanel();
        comp.setOpaque(false);
        panel.add((Component)comp, contraint);
        return panel;
    }
}

