/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import org.openconcerto.ui.FormatEditor;
import org.openconcerto.ui.PopupUtils;
import org.openconcerto.ui.TimestampEditorPanel;

public class TimestampTableCellEditor
extends FormatEditor
implements ActionListener {
    private Calendar calendar;
    private Date currentvalue;
    private Date initialvalue;
    private Popup aPopup;
    boolean popupOpen = false;
    private TimestampEditorPanel content = new TimestampEditorPanel();

    public TimestampTableCellEditor(boolean showHour) {
        this();
        this.content.setHourVisible(showHour);
    }

    public TimestampTableCellEditor() {
        super(DateFormat.getDateTimeInstance(3, 3));
        this.calendar = Calendar.getInstance();
        this.content.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        Date time = (Date)value;
        if (time == null) {
            time = new Timestamp(System.currentTimeMillis());
        }
        this.content.setTime(time);
        this.calendar.setTime(time);
        this.currentvalue = time;
        this.initialvalue = time;
        Rectangle rect = table.getCellRect(row, column, true);
        Point p = new Point(rect.x, rect.y + table.getRowHeight(row));
        SwingUtilities.convertPointToScreen(p, table);
        if (this.aPopup != null) {
            this.content.removeActionListener(this);
            this.aPopup.hide();
            this.aPopup = null;
        }
        this.aPopup = PopupUtils.createPopup(table, this.content, p.x, p.y);
        this.showPopup();
        this.content.setCellEditor(this);
        this.content.addActionListener(this);
        return c;
    }

    @Override
    public void cancelCellEditing() {
        if (this.popupOpen) {
            return;
        }
        this.hidePopup();
        this.currentvalue = this.initialvalue;
        super.cancelCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        if (this.popupOpen) {
            return false;
        }
        this.hidePopup();
        return super.stopCellEditing();
    }

    public void hidePopup() {
        this.popupOpen = false;
        this.content.removeActionListener(this);
        if (this.aPopup != null) {
            this.aPopup.hide();
            this.aPopup = null;
        }
    }

    public void showPopup() {
        this.popupOpen = true;
        this.aPopup.show();
    }

    @Override
    public Object getCellEditorValue() {
        Date v = (Date)super.getCellEditorValue();
        long t = System.currentTimeMillis();
        if (v != null) {
            t = v.getTime();
        }
        if (v == null) {
            Object n = null;
            return n;
        }
        return new Timestamp(t);
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.currentvalue = this.content.getTime();
        this.delegate.setValue(this.currentvalue);
    }
}

