/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.openconcerto.ui.table.TablePopupMenuProvider;

public class PopUpTableManager
extends MouseAdapter {
    private final transient JTable table;
    private final transient TablePopupMenuProvider provider;

    public PopUpTableManager(JTable table, TablePopupMenuProvider provider) {
        table.addMouseListener(this);
        this.table = table;
        this.provider = provider;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.showPopup(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.showPopup(event);
    }

    private void showPopup(MouseEvent event) {
        if (event.isPopupTrigger()) {
            JPopupMenu popupMenu = new JPopupMenu();
            int row = this.table.rowAtPoint(event.getPoint());
            List<Action> actions = this.provider.getActions(this.table, row);
            int size = actions.size();
            int i = 0;
            while (i < size) {
                popupMenu.add(actions.get(i));
                ++i;
            }
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        }
    }
}

