/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.state;

import java.io.File;
import java.io.IOException;

public abstract class AbstractStateManager<T> {
    private File configFile;
    private final T src;

    public AbstractStateManager(T src, File f) {
        this(src, f, true);
    }

    public AbstractStateManager(T src, File f, boolean autosave) {
        this.src = src;
        this.configFile = f;
        if (autosave) {
            this.beginAutoSave();
        }
    }

    public final File getConfigFile() {
        return this.configFile;
    }

    public final void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    protected final T getSrc() {
        return this.src;
    }

    public abstract void beginAutoSave();

    public abstract void endAutoSave();

    public final void deleteState() {
        this.check();
        this.configFile.delete();
    }

    private void check() {
        if (this.configFile == null) {
            throw new IllegalStateException("configFile undefined.");
        }
    }

    public final void saveState() throws IOException {
        this.check();
        this.saveState(this.configFile);
    }

    public final void saveState(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null File specified");
        }
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        this.writeState(file);
    }

    protected abstract void writeState(File var1) throws IOException;

    public final boolean loadState() {
        this.check();
        return this.loadState(this.configFile);
    }

    public final boolean loadState(File file) {
        if (file.exists() && file.length() > 0L) {
            this.configFile = file;
            return this.readState(file);
        }
        return false;
    }

    protected abstract boolean readState(File var1);
}

