/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import org.openconcerto.ui.preferences.PrefView;
import org.openconcerto.ui.preferences.PreferencePanel;
import org.openconcerto.ui.preferences.PreferencePanelListener;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.AutoLayouter;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.checks.ValidChangeSupport;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;

public abstract class JavaPrefPreferencePanel
extends JPanel
implements PreferencePanel {
    private final String title;
    private Preferences prefs;
    private final AutoLayouter layouter;
    private final Set<PrefView<?>> views;
    private boolean modified;
    private final ValidChangeSupport validSupp;
    private String invalidityCause;

    public JavaPrefPreferencePanel(String title, Preferences prefs) {
        this.title = title;
        this.prefs = prefs;
        this.layouter = new AutoLayouter(this);
        this.views = new HashSet();
        this.modified = false;
        this.validSupp = new ValidChangeSupport(this);
        this.invalidityCause = null;
    }

    public final void setPrefs(Preferences prefs) {
        if (this.prefs != null) {
            throw new IllegalStateException("Already set : " + this.prefs);
        }
        this.prefs = prefs;
    }

    @Override
    public final String getTitleName() {
        return this.title;
    }

    public final String getPrefPath() {
        return this.prefs.absolutePath();
    }

    @Override
    public void uiInit() {
        if (this.prefs == null) {
            throw new NullPointerException("prefs wasn't set");
        }
        this.addViews();
        this.reset();
    }

    protected abstract void addViews();

    protected final void addView(final PrefView<?> view) {
        ValueWrapper<?> vw = view.getVW();
        this.layouter.add(view.getName(), vw.getComp());
        this.views.add(view);
        view.init(this);
        vw.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!view.equalsToPrefValue(JavaPrefPreferencePanel.this.prefs)) {
                    JavaPrefPreferencePanel.this.setModified(true);
                }
            }
        });
        vw.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, boolean newValue) {
                JavaPrefPreferencePanel.this.validSupp.fireValidChange(JavaPrefPreferencePanel.this.isValidated());
            }
        });
    }

    public final void reset() {
        for (PrefView<?> v : this.views) {
            v.setViewValue(this.prefs);
        }
        this.setModified(false);
    }

    @Override
    public final void apply() {
        if (this.isModified()) {
            try {
                for (PrefView<?> v : this.views) {
                    v.setPrefValue(this.prefs);
                }
                this.prefs.sync();
                this.reset();
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException("Couldn't store values", e);
            }
        }
    }

    @Override
    public final void restoreToDefaults() {
        for (PrefView<?> v : this.views) {
            v.resetViewValue();
        }
    }

    @Override
    public final void addModifyChangeListener(PreferencePanelListener l) {
        throw new UnsupportedOperationException();
    }

    private final void setModified(boolean modified) {
        if (this.modified != modified) {
            this.modified = modified;
        }
    }

    @Override
    public final boolean isModified() {
        return this.modified;
    }

    @Override
    public final boolean isValidated() {
        boolean res = true;
        ArrayList<String> pbs = new ArrayList<String>();
        for (PrefView<?> v : this.views) {
            if (v.getVW().isValidated()) continue;
            String explanation = "'" + v.getName() + "' n'est pas valide";
            String txt = v.getVW().getValidationText();
            if (txt != null) {
                explanation = String.valueOf(explanation) + " (" + txt + ")";
            }
            pbs.add(explanation);
            res = false;
        }
        this.invalidityCause = res ? null : CollectionUtils.join(pbs, "\n");
        return res;
    }

    @Override
    public final String getValidationText() {
        return this.invalidityCause;
    }

    @Override
    public final void addValidListener(ValidListener l) {
        this.validSupp.addValidListener(l);
    }

    @Override
    public final void removeValidListener(ValidListener l) {
        this.validSupp.removeValidListener(l);
    }
}

