/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.openconcerto.utils.FileUtils;

public abstract class AbstractProps {
    protected final Properties props = new Properties();

    protected AbstractProps() {
        this.load();
    }

    public Properties getProps() {
        return this.props;
    }

    protected abstract String getPropsFileName();

    public final boolean contains(String name) {
        return this.props.containsKey(String.valueOf(name) + this.getPropertySuffix());
    }

    public String getPropertySuffix() {
        return "";
    }

    public String getStringProperty(String name) {
        String property = this.getProperty(name);
        if (property == null) {
            return this.getDefaultStringValue();
        }
        return property;
    }

    public final String getProperty(String name) {
        String key = String.valueOf(name) + this.getPropertySuffix();
        String property = this.props.getProperty(key);
        return property;
    }

    public final Boolean getBooleanValue(String name) {
        String property = this.getProperty(name);
        if (property == null) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(property);
    }

    public final boolean getBooleanValue(String name, boolean defaultValue) {
        String property = this.getProperty(name);
        if (property == null) {
            return defaultValue;
        }
        return Boolean.valueOf(property);
    }

    public String getDefaultStringValue() {
        return "";
    }

    public int getIntProperty(String name) {
        String property = this.getProperty(name);
        int result = property == null ? this.getDefautIntValue() : Integer.valueOf(property).intValue();
        return result;
    }

    protected int getDefautIntValue() {
        return -1;
    }

    public void setProperty(String key, String value) {
        String fullKey = String.valueOf(key) + this.getPropertySuffix();
        if (value == null) {
            this.props.remove(fullKey);
        } else {
            this.props.setProperty(fullKey, value);
        }
    }

    public void load() {
        block13: {
            File file = new File(this.getPropsFileName());
            if (!file.exists()) {
                return;
            }
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    bufferedInputStream = new BufferedInputStream(fileInputStream);
                    this.props.load(bufferedInputStream);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(new JFrame(), "Impossible de lire le fichier de configuration:\n" + file.getAbsolutePath());
                    e.printStackTrace();
                    if (bufferedInputStream == null) break block13;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void store() {
        block12: {
            FilterOutputStream bufferedOutputStream = null;
            File file = new File(this.getPropsFileName());
            try {
                try {
                    FileUtils.mkdir_p(file.getParentFile());
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    this.props.store(bufferedOutputStream, "");
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(new JFrame(), "Impossible d'enregistrer le fichier de configuration:\n" + file.getAbsolutePath());
                    e.printStackTrace();
                    if (bufferedOutputStream == null) break block12;
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

